/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Asset;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import java.util.List;

class ConversionHelper {
    private ConversionHelper() {
    }

    static Document validateDocumentSize(Document document) {
        Preconditions.checkNotNull(document);
        int size = 0;
        for (Asset asset : document.getAssets()) {
            size += asset.getData().length;
        }
        Preconditions.checkArgument(size <= 0x200000, String.format("Each conversion should not be over %d bytes.", 0x200000));
        return document;
    }

    static Document validateInputDoc(Document document) {
        Preconditions.checkNotNull(document);
        List<Asset> assets = document.getAssets();
        for (Asset asset : assets.subList(1, assets.size())) {
            Preconditions.checkArgument(!StringUtil.isEmptyOrWhitespace(asset.getName()), "Additional asset name should not be null, empty or comprises only whitespaces");
        }
        return document;
    }
}

