/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.BooleanMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class BooleanObjectArrayMorpher
extends AbstractArrayMorpher {
    private static final Class BOOLEAN_OBJECT_ARRAY_CLASS = Boolean[].class;
    private Boolean defaultValue;

    public BooleanObjectArrayMorpher() {
        super(false);
    }

    public BooleanObjectArrayMorpher(Boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanObjectArrayMorpher)) {
            return false;
        }
        BooleanObjectArrayMorpher other = (BooleanObjectArrayMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append((Object)this.getDefaultValue(), (Object)other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append((Object)this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BOOLEAN_OBJECT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (Boolean[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Boolean.class, dimensions);
            if (dims == 1) {
                BooleanMorpher morpher = null;
                if (this.isUseDefault()) {
                    if (this.defaultValue == null) {
                        int index = 0;
                        while (index < length) {
                            Array.set(result, index, null);
                            ++index;
                        }
                        return result;
                    }
                    morpher = new BooleanMorpher(this.defaultValue);
                } else {
                    morpher = new BooleanMorpher();
                }
                int index = 0;
                while (index < length) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)) ? Boolean.TRUE : Boolean.FALSE);
                    ++index;
                }
            } else {
                int index = 0;
                while (index < length) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                    ++index;
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    public Class morphsTo() {
        return BOOLEAN_OBJECT_ARRAY_CLASS;
    }
}

