/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session.defaults;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.result.DefaultMapResultHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSqlSession
implements SqlSession {
    private Configuration configuration;
    private Executor executor;
    private boolean autoCommit;
    private boolean dirty;

    public DefaultSqlSession(Configuration configuration, Executor executor, boolean autoCommit) {
        this.configuration = configuration;
        this.executor = executor;
        this.autoCommit = autoCommit;
        this.dirty = false;
    }

    @Override
    public Object selectOne(String statement) {
        return this.selectOne(statement, null);
    }

    @Override
    public Object selectOne(String statement, Object parameter) {
        List list = this.selectList(statement, parameter);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + list.size());
        }
        return null;
    }

    @Override
    public Map selectMap(String statement, String mapKey) {
        return this.selectMap(statement, null, mapKey, RowBounds.DEFAULT);
    }

    @Override
    public Map selectMap(String statement, Object parameter, String mapKey) {
        return this.selectMap(statement, parameter, mapKey, RowBounds.DEFAULT);
    }

    @Override
    public Map selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        List list = this.selectList(statement, parameter, rowBounds);
        DefaultMapResultHandler mapResultHandler = new DefaultMapResultHandler(mapKey);
        DefaultResultContext context = new DefaultResultContext();
        for (Object o : list) {
            context.nextResultObject(o);
            mapResultHandler.handleResult(context);
        }
        return mapResultHandler.getMappedResults();
    }

    @Override
    public List selectList(String statement) {
        return this.selectList(statement, null);
    }

    @Override
    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, RowBounds.DEFAULT);
    }

    @Override
    public List selectList(String statement, Object parameter, RowBounds rowBounds) {
        List list;
        try {
            MappedStatement ms = this.configuration.getMappedStatement(statement);
            list = this.executor.query(ms, this.wrapCollection(parameter), rowBounds, Executor.NO_RESULT_HANDLER);
            Object var7_7 = null;
            ErrorContext.instance().reset();
        }
        catch (Exception e) {
            try {
                throw ExceptionFactory.wrapException("Error querying database.  Cause: " + e, e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ErrorContext.instance().reset();
                throw throwable;
            }
        }
        return list;
    }

    @Override
    public void select(String statement, Object parameter, ResultHandler handler) {
        this.select(statement, parameter, RowBounds.DEFAULT, handler);
    }

    @Override
    public void select(String statement, ResultHandler handler) {
        this.select(statement, null, RowBounds.DEFAULT, handler);
    }

    @Override
    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        try {
            try {
                MappedStatement ms = this.configuration.getMappedStatement(statement);
                this.executor.query(ms, this.wrapCollection(parameter), rowBounds, handler);
            }
            catch (Exception e) {
                throw ExceptionFactory.wrapException("Error querying database.  Cause: " + e, e);
            }
            Object var7_7 = null;
            ErrorContext.instance().reset();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ErrorContext.instance().reset();
            throw throwable;
        }
    }

    @Override
    public int insert(String statement) {
        return this.insert(statement, null);
    }

    @Override
    public int insert(String statement, Object parameter) {
        return this.update(statement, parameter);
    }

    @Override
    public int update(String statement) {
        return this.update(statement, null);
    }

    @Override
    public int update(String statement, Object parameter) {
        int n;
        try {
            this.dirty = true;
            MappedStatement ms = this.configuration.getMappedStatement(statement);
            n = this.executor.update(ms, this.wrapCollection(parameter));
            Object var6_6 = null;
            ErrorContext.instance().reset();
        }
        catch (Exception e) {
            try {
                throw ExceptionFactory.wrapException("Error updating database.  Cause: " + e, e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ErrorContext.instance().reset();
                throw throwable;
            }
        }
        return n;
    }

    @Override
    public int delete(String statement) {
        return this.update(statement, null);
    }

    @Override
    public int delete(String statement, Object parameter) {
        return this.update(statement, this.wrapCollection(parameter));
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        try {
            try {
                this.executor.commit(this.isCommitOrRollbackRequired(force));
                this.dirty = false;
            }
            catch (Exception e) {
                throw ExceptionFactory.wrapException("Error committing transaction.  Cause: " + e, e);
            }
            Object var4_2 = null;
            ErrorContext.instance().reset();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ErrorContext.instance().reset();
            throw throwable;
        }
    }

    @Override
    public void rollback() {
        this.rollback(false);
    }

    @Override
    public void rollback(boolean force) {
        try {
            try {
                this.executor.rollback(this.isCommitOrRollbackRequired(force));
                this.dirty = false;
            }
            catch (Exception e) {
                throw ExceptionFactory.wrapException("Error rolling back transaction.  Cause: " + e, e);
            }
            Object var4_2 = null;
            ErrorContext.instance().reset();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ErrorContext.instance().reset();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.executor.close(this.isCommitOrRollbackRequired(false));
            this.dirty = false;
            Object var2_1 = null;
            ErrorContext.instance().reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            ErrorContext.instance().reset();
            throw throwable;
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T> T getMapper(Class<T> type) {
        return this.configuration.getMapper(type, this);
    }

    @Override
    public Connection getConnection() {
        return this.executor.getTransaction().getConnection();
    }

    @Override
    public void clearCache() {
        this.executor.clearLocalCache();
    }

    private boolean isCommitOrRollbackRequired(boolean force) {
        return !this.autoCommit && this.dirty || force;
    }

    private Object wrapCollection(final Object object) {
        if (object instanceof List) {
            return new HashMap(){
                {
                    this.put("list", object);
                }
            };
        }
        if (object != null && object.getClass().isArray()) {
            return new HashMap(){
                {
                    this.put("array", object);
                }
            };
        }
        return object;
    }
}

