/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.types;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnDirScanner
extends DirectoryScanner {
    private static final boolean ON_VMS = Os.isFamily((String)"openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final Vector<String> defaultExcludes = new Vector();
    private static final FileUtils fileUtils = FileUtils.newFileUtils();
    private ISVNClientAdapter svnClient;
    private Map<File, ISVNStatus[]> fileListMap = new HashMap<File, ISVNStatus[]>();
    private File basedir;
    private String[] includes;
    private String[] excludes;
    private FileSelector[] selectors = null;
    private Vector<String> filesIncluded;
    private Vector<String> filesNotIncluded;
    private Vector<String> filesExcluded;
    private Vector<String> dirsIncluded;
    private Vector<String> dirsNotIncluded;
    private Vector<String> dirsExcluded;
    private Vector<String> filesDeselected;
    private Vector<String> dirsDeselected;
    private boolean haveSlowResults = false;
    private boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    private boolean everythingIncluded = true;
    private Set<String> scannedDirs = new HashSet<String>();

    public SvnDirScanner(ISVNClientAdapter iSVNClientAdapter) {
        this.svnClient = iSVNClientAdapter;
    }

    private ISVNStatus[] list(File file) {
        ISVNStatus[] iSVNStatusArray = this.fileListMap.get(file);
        if (iSVNStatusArray == null) {
            try {
                iSVNStatusArray = this.svnClient.getStatus(file, false, true);
            }
            catch (SVNClientException sVNClientException) {
                throw new RuntimeException("Error scanning: " + (Object)((Object)sVNClientException), sVNClientException);
            }
            int n = 0;
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                if (iSVNStatusArray[i].getFile().equals(file)) continue;
                ++n;
            }
            ISVNStatus[] iSVNStatusArray2 = new ISVNStatus[n];
            int n2 = 0;
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                if (iSVNStatusArray[i].getFile().equals(file)) continue;
                iSVNStatusArray2[n2] = iSVNStatusArray[i];
                ++n2;
            }
            iSVNStatusArray = iSVNStatusArray2;
            this.fileListMap.put(file, iSVNStatusArray);
        }
        return iSVNStatusArray;
    }

    protected static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart((String)string, (String)string2);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl) {
        return SelectorUtils.matchPatternStart((String)string, (String)string2, (boolean)bl);
    }

    protected static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath((String)string, (String)string2);
    }

    protected static boolean matchPath(String string, String string2, boolean bl) {
        return SelectorUtils.matchPath((String)string, (String)string2, (boolean)bl);
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match((String)string, (String)string2);
    }

    protected static boolean match(String string, String string2, boolean bl) {
        return SelectorUtils.match((String)string, (String)string2, (boolean)bl);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String string) {
        if (defaultExcludes.indexOf(string) == -1) {
            defaultExcludes.add(string);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String string) {
        return defaultExcludes.remove(string);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes.clear();
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
        }
    }

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.includes[i] = string;
            }
        }
    }

    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.excludes[i] = string;
            }
        }
    }

    public void setSelectors(FileSelector[] fileSelectorArray) {
        this.selectors = fileSelectorArray;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.checkIncludePatterns();
        this.clearCaches();
    }

    private void checkIncludePatterns() {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.includes.length; ++i) {
            object = SelectorUtils.rtrimWildcardTokens((String)this.includes[i]);
            hashtable.put((String)object, this.includes[i]);
        }
        if (hashtable.containsKey("")) {
            this.scandir(this.basedir, "", true);
        } else {
            Enumeration enumeration = hashtable.keys();
            object = null;
            try {
                object = this.basedir.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            while (enumeration.hasMoreElements()) {
                File file;
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                File file2 = new File(this.basedir, string);
                if (file2.exists()) {
                    try {
                        file = file2.getCanonicalFile();
                        String string3 = fileUtils.removeLeadingPath((File)object, file);
                        if ((!string3.equals(string) || ON_VMS) && (file2 = this.findFile(this.basedir, string)) != null) {
                            string = fileUtils.removeLeadingPath(this.basedir, file2);
                        }
                    }
                    catch (IOException iOException) {
                        throw new BuildException((Throwable)iOException);
                    }
                }
                if (!(file2 != null && file2.exists() || this.isCaseSensitive || !(file = this.findFileCaseInsensitive(this.basedir, string)).exists())) {
                    string = fileUtils.removeLeadingPath(this.basedir, file);
                    file2 = file;
                }
                if (file2 == null || !file2.exists() || !this.followSymlinks && this.isSymlink(this.basedir, string)) continue;
                if (file2.isDirectory()) {
                    if (this.isIncluded(string) && string.length() > 0) {
                        this.accountForIncludedDir(string, file2, true);
                        continue;
                    }
                    if (string.length() > 0 && string.charAt(string.length() - 1) != File.separatorChar) {
                        string = string + File.separatorChar;
                    }
                    this.scandir(file2, string, true);
                    continue;
                }
                if (this.isCaseSensitive && string2.equals(string)) {
                    this.accountForIncludedFile(string, file2);
                    continue;
                }
                if (this.isCaseSensitive || !string2.equalsIgnoreCase(string)) continue;
                this.accountForIncludedFile(string, file2);
            }
        }
    }

    protected void slowScan() {
        int n;
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        for (n = 0; n < objectArray.length; ++n) {
            if (this.couldHoldIncluded((String)objectArray[n])) continue;
            this.scandir(new File(this.basedir, (String)objectArray[n]), (String)objectArray[n] + File.separator, false);
        }
        for (n = 0; n < objectArray2.length; ++n) {
            if (this.couldHoldIncluded((String)objectArray2[n])) continue;
            this.scandir(new File(this.basedir, (String)objectArray2[n]), (String)objectArray2[n] + File.separator, false);
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File file, String string, boolean bl) {
        if (bl && this.hasBeenScanned(string)) {
            return;
        }
        ISVNStatus[] iSVNStatusArray = this.list(file);
        if (iSVNStatusArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        for (int i = 0; i < iSVNStatusArray.length; ++i) {
            String string2 = string + iSVNStatusArray[i].getFile().getName();
            File file2 = new File(file, iSVNStatusArray[i].getFile().getName());
            if (SVNNodeKind.DIR == iSVNStatusArray[i].getNodeKind() || SVNNodeKind.UNKNOWN == iSVNStatusArray[i].getNodeKind() && iSVNStatusArray[i].getFile().isDirectory()) {
                if (this.isIncluded(string2)) {
                    this.accountForIncludedDir(string2, file2, bl);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (bl && this.couldHoldIncluded(string2)) {
                        this.scandir(file2, string2 + File.separator, bl);
                    }
                }
                if (bl) continue;
                this.scandir(file2, string2 + File.separator, bl);
                continue;
            }
            if (SVNNodeKind.FILE != iSVNStatusArray[i].getNodeKind() && (SVNNodeKind.UNKNOWN != iSVNStatusArray[i].getNodeKind() || !iSVNStatusArray[i].getFile().isFile())) continue;
            if (this.isIncluded(string2)) {
                this.accountForIncludedFile(string2, file2);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(string2);
        }
    }

    private void accountForIncludedFile(String string, File file) {
        if (!(this.filesIncluded.contains(string) || this.filesExcluded.contains(string) || this.filesDeselected.contains(string))) {
            if (!this.isExcluded(string)) {
                if (this.isSelected(string, file)) {
                    this.filesIncluded.addElement(string);
                } else {
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(string);
                }
            } else {
                this.everythingIncluded = false;
                this.filesExcluded.addElement(string);
            }
        }
    }

    private void accountForIncludedDir(String string, File file, boolean bl) {
        if (!(this.dirsIncluded.contains(string) || this.dirsExcluded.contains(string) || this.dirsDeselected.contains(string))) {
            if (!this.isExcluded(string)) {
                if (this.isSelected(string, file)) {
                    this.dirsIncluded.addElement(string);
                    if (bl) {
                        this.scandir(file, string + File.separator, bl);
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsDeselected.addElement(string);
                    if (bl && this.couldHoldIncluded(string)) {
                        this.scandir(file, string + File.separator, bl);
                    }
                }
            } else {
                this.everythingIncluded = false;
                this.dirsExcluded.addElement(string);
                if (bl && this.couldHoldIncluded(string)) {
                    this.scandir(file, string + File.separator, bl);
                }
            }
        }
    }

    protected boolean isIncluded(String string) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!SvnDirScanner.matchPath(this.includes[i], string, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!SvnDirScanner.matchPatternStart(this.includes[i], string, this.isCaseSensitive) || !this.isMorePowerfulThanExcludes(string, this.includes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isMorePowerfulThanExcludes(String string, String string2) {
        String string3 = string + File.separator + "**";
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!this.excludes[i].equals(string3)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String string) {
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!SvnDirScanner.matchPath(this.excludes[i], string, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String string, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, string, file)) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] objectArray = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(objectArray);
        return objectArray;
    }

    public String[] getIncludedDirectories() {
        Object[] objectArray = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(objectArray);
        return objectArray;
    }

    public void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + defaultExcludes.size()];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        String[] stringArray2 = SvnDirScanner.getDefaultExcludes();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[i + n] = stringArray2[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = stringArray;
    }

    public Resource getResource(String string) {
        File file = fileUtils.resolveFile(this.basedir, string);
        return new Resource(string, file.exists(), file.lastModified(), file.isDirectory());
    }

    private File findFileCaseInsensitive(File file, String string) {
        File file2 = this.findFileCaseInsensitive(file, SelectorUtils.tokenizePath((String)string));
        return file2 == null ? new File(file, string) : file2;
    }

    private File findFileCaseInsensitive(File file, Vector<String> vector) {
        String string;
        int n;
        if (vector.isEmpty()) {
            return file;
        }
        if (!file.isDirectory()) {
            return null;
        }
        ISVNStatus[] iSVNStatusArray = this.list(file);
        if (iSVNStatusArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        String string2 = vector.remove(0);
        for (n = 0; n < iSVNStatusArray.length; ++n) {
            string = iSVNStatusArray[n].getFile().getName();
            if (!string.equals(string2)) continue;
            return this.findFileCaseInsensitive(new File(file, string), vector);
        }
        for (n = 0; n < iSVNStatusArray.length; ++n) {
            string = iSVNStatusArray[n].getFile().getName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return this.findFileCaseInsensitive(new File(file, string), vector);
        }
        return null;
    }

    private File findFile(File file, String string) {
        return this.findFile(file, SelectorUtils.tokenizePath((String)string));
    }

    private File findFile(File file, Vector<String> vector) {
        if (vector.isEmpty()) {
            return file;
        }
        if (!file.isDirectory()) {
            return null;
        }
        ISVNStatus[] iSVNStatusArray = this.list(file);
        if (iSVNStatusArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        String string = vector.remove(0);
        for (int i = 0; i < iSVNStatusArray.length; ++i) {
            String string2 = iSVNStatusArray[i].getFile().getName();
            if (!string2.equals(string)) continue;
            return this.findFile(new File(file, string2), vector);
        }
        return null;
    }

    private boolean isSymlink(File file, String string) {
        return this.isSymlink(file, SelectorUtils.tokenizePath((String)string));
    }

    private boolean isSymlink(File file, Vector<String> vector) {
        if (vector.size() > 0) {
            String string = vector.remove(0);
            try {
                if (fileUtils.isSymbolicLink(file, string)) {
                    return true;
                }
                return this.isSymlink(new File(file, string), vector);
            }
            catch (IOException iOException) {
                String string2 = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(string2);
                return false;
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String string) {
        return !this.scannedDirs.add(string);
    }

    private void clearCaches() {
        this.fileListMap.clear();
        this.scannedDirs.clear();
    }

    static {
        SvnDirScanner.resetDefaultExcludes();
    }
}

