/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.apache.tools.ant.Project;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class WcVersion
extends SvnCommand {
    private static final String MSG_CANT_GET_SUMMARY = "Can't get summary status for path %s";
    private static final String MSG_UNMANAGED_PATH = "The path '%s' is not under version control !";
    private File path;
    private String prefix;
    private boolean processUnversioned = false;

    public void execute() {
        WCVersionSummary wCVersionSummary;
        try {
            wCVersionSummary = this.getWorkingCopySumary(this.getPath());
        }
        catch (SVNClientException sVNClientException) {
            throw WcVersion.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_SUMMARY, this.getPath());
        }
        Project project = this.getProject();
        if (this.prefix == null) {
            this.prefix = "";
        } else if (!this.prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
        project.setNewProperty(this.prefix + "repository.url", wCVersionSummary.reposURL);
        project.setNewProperty(this.prefix + "repository.path", wCVersionSummary.reposPath);
        project.setNewProperty(this.prefix + "revision.max", wCVersionSummary.getMaxRevision());
        project.setNewProperty(this.prefix + "revision.max-with-flags", wCVersionSummary.getMaxRevisionWithFlags());
        project.setNewProperty(this.prefix + "revision.range", wCVersionSummary.getRevisionRange());
        project.setNewProperty(this.prefix + "committed.max", wCVersionSummary.getMaxCommitted());
        project.setNewProperty(this.prefix + "committed.max-with-flags", wCVersionSummary.getMaxCommittedWithFlags());
        if (wCVersionSummary.hasModified) {
            project.setNewProperty(this.prefix + "modified", "true");
        }
        if (wCVersionSummary.hasMixed) {
            project.setNewProperty(this.prefix + "mixed", "true");
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrIsDirectory("path", this.path);
    }

    private WCVersionSummary getWorkingCopySumary(File file) throws SVNClientException {
        ISVNStatus iSVNStatus = this.getClient().getSingleStatus(file);
        if (iSVNStatus.getUrl() == null) {
            throw WcVersion.ex(MSG_UNMANAGED_PATH, file.getAbsolutePath());
        }
        ISVNStatus[] iSVNStatusArray = this.getClient().getStatus(file, true, true);
        return new WCVersionSummary(iSVNStatus, iSVNStatusArray, file, this.processUnversioned);
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public boolean getProcessUnversioned() {
        return this.processUnversioned;
    }

    public void setProcessUnversioned(boolean bl) {
        this.processUnversioned = bl;
    }

    private static class WCVersionSummary {
        protected long maxRevision = 0L;
        protected long maxCommitted = 0L;
        protected long minRevision = 0L;
        protected boolean hasModified = false;
        protected boolean hasMixed = false;
        protected String reposURL;
        protected String reposPath;

        protected WCVersionSummary(ISVNStatus iSVNStatus, ISVNStatus[] iSVNStatusArray, File file, boolean bl) {
            int n;
            this.reposURL = iSVNStatus.getUrl().toString();
            String[] stringArray = iSVNStatus.getUrl().getPathSegments();
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append('/').append(stringArray[n]);
            }
            this.reposPath = stringBuffer.toString();
            for (n = 0; n < iSVNStatusArray.length; ++n) {
                SVNRevision.Number number;
                long l;
                long l2;
                ISVNStatus iSVNStatus2 = iSVNStatusArray[n];
                if (!SVNStatusUtils.isManaged((ISVNStatus)iSVNStatus2) && !bl) continue;
                if (!this.hasModified && (iSVNStatus2.getTextStatus() != SVNStatusKind.NORMAL && iSVNStatus2.getTextStatus() != SVNStatusKind.IGNORED || iSVNStatus2.getPropStatus() != SVNStatusKind.NORMAL && iSVNStatus2.getPropStatus() != SVNStatusKind.NONE)) {
                    this.hasModified = true;
                }
                if (!SVNStatusUtils.isManaged((ISVNStatus)iSVNStatus2) || this.isExternal(iSVNStatus, iSVNStatus2)) continue;
                SVNRevision.Number number2 = iSVNStatus2.getLastChangedRevision();
                long l3 = l2 = number2 != null ? number2.getNumber() : 0L;
                if (l2 > this.maxRevision) {
                    this.maxRevision = l2;
                }
                if (l2 < this.minRevision) {
                    this.minRevision = l2;
                }
                long l4 = l = (number = iSVNStatus2.getLastChangedRevision()) != null ? number.getNumber() : 0L;
                if (l <= this.maxCommitted) continue;
                this.maxCommitted = l;
            }
            if (this.minRevision > 0L && this.minRevision != this.maxRevision) {
                this.hasMixed = true;
            }
        }

        private boolean isExternal(ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
            return !iSVNStatus2.getUrlString().startsWith(iSVNStatus.getUrlString());
        }

        protected String getMaxRevision() {
            return String.valueOf(this.maxRevision);
        }

        protected String getMaxRevisionWithFlags() {
            return this.getMaxRevision() + this.getFlags();
        }

        protected String getMaxCommitted() {
            return String.valueOf(this.maxCommitted);
        }

        protected String getMaxCommittedWithFlags() {
            return this.getMaxCommitted() + this.getFlags();
        }

        protected String getRevisionRange() {
            if (this.hasMixed) {
                return String.valueOf(this.minRevision) + ":" + this.getMaxRevisionWithFlags();
            }
            return this.getMaxRevisionWithFlags();
        }

        private String getFlags() {
            return (this.hasModified ? "M" : "") + (this.hasMixed ? "X" : "");
        }
    }
}

