/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Switch
extends SvnCommand {
    private static final String MSG_CANNOT_SWITCH = "Cannot switch to url : %s";
    private File path = null;
    private SVNUrl url;
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean recurse = true;

    public void execute() {
        try {
            this.getClient().switchToUrl(this.path, this.url, this.revision, this.recurse);
        }
        catch (SVNClientException sVNClientException) {
            throw Switch.ex((Exception)((Object)sVNClientException), MSG_CANNOT_SWITCH, this.url.toString());
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("path", this.path);
        SvnAntUtilities.attrNotNull("url", this.url);
        SvnAntUtilities.attrNotNull("revision", this.revision);
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }
}

