/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.Date;
import org.apache.tools.ant.Project;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Status
extends SvnCommand {
    private static final String MSG_CANT_GET_STATUS = "Can't get status of %s";
    private File path = null;
    private String textStatusProperty = null;
    private String propStatusProperty = null;
    private String revisionProperty = null;
    private String lastChangedRevisionProperty = null;
    private String lastChangedDateProperty = null;
    private String lastCommitAuthorProperty = null;
    private String urlProperty = null;

    public void execute() {
        Project project = this.getProject();
        try {
            Object object;
            ISVNStatus iSVNStatus = this.getClient().getSingleStatus(this.path);
            if (this.textStatusProperty != null) {
                project.setProperty(this.textStatusProperty, iSVNStatus.getTextStatus().toString());
            }
            if (this.propStatusProperty != null) {
                project.setProperty(this.propStatusProperty, iSVNStatus.getPropStatus().toString());
            }
            if (this.revisionProperty != null) {
                object = null == iSVNStatus.getRevision() ? "-1" : iSVNStatus.getRevision().toString();
                project.setProperty(this.revisionProperty, (String)object);
            }
            if (this.lastChangedRevisionProperty != null) {
                object = iSVNStatus.getLastChangedRevision() == null ? "" : iSVNStatus.getLastChangedRevision().toString();
                project.setProperty(this.lastChangedRevisionProperty, (String)object);
            }
            if (this.lastCommitAuthorProperty != null) {
                object = iSVNStatus.getLastCommitAuthor();
                if (object == null) {
                    object = "";
                }
                project.setProperty(this.lastCommitAuthorProperty, (String)object);
            }
            if (this.lastChangedDateProperty != null) {
                object = iSVNStatus.getLastChangedDate();
                if (object == null) {
                    project.setProperty(this.lastChangedDateProperty, "");
                } else {
                    project.setProperty(this.lastChangedDateProperty, this.getDateStringFor((Date)object));
                }
            }
            if (this.urlProperty != null) {
                object = iSVNStatus.getUrl();
                project.setProperty(this.urlProperty, object != null ? object.toString() : "");
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Status.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_STATUS, this.path);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("path", this.path);
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setTextStatusProperty(String string) {
        this.textStatusProperty = string;
    }

    public void setPropStatusProperty(String string) {
        this.propStatusProperty = string;
    }

    public void setRevisionProperty(String string) {
        this.revisionProperty = string;
    }

    public void setLastChangedRevisionProperty(String string) {
        this.lastChangedRevisionProperty = string;
    }

    public void setLastCommitAuthorProperty(String string) {
        this.lastCommitAuthorProperty = string;
    }

    public void setLastChangedDateProperty(String string) {
        this.lastChangedDateProperty = string;
    }

    public void setUrlProperty(String string) {
        this.urlProperty = string;
    }
}

