/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SingleInfo
extends SvnCommand {
    private static final String MSG_FAILED_TO_ACCESS_PROPERTIES = "Failed to access subversion 'info' properties";
    private static final String MSG_PROPERTY_NOT_IMPLEMENTED = "Property '%s' not implemented";
    private static final String MSG_PROPERTY_NOT_RECOGNIZED = "Property '%s' not recognized";
    private static final String MSG_UNVERSIONED_RESOURCE = "%s - Not a versioned resource";
    private static final String PROP_PATH = "path";
    private static final String PROP_URL = "url";
    private static final String PROP_REPOURL = "repourl";
    private static final String PROP_REPOUUID = "repouuid";
    private static final String PROP_REV = "revision";
    private static final String PROP_NODEKIND = "nodekind";
    private static final String PROP_SCHEDULE = "schedule";
    private static final String PROP_AUTHOR = "author";
    private static final String PROP_LASTREV = "lastRevision";
    private static final String PROP_LASTDATE = "lastDate";
    private static final String PROP_NAME = "name";
    private static final String PROP_LASTTEXTUPDATE = "lastTextUpdate";
    private static final String PROP_LASTPROPUPDATE = "lastPropUpdate";
    private static final String PROP_CHECKSUM = "checksum";
    private static final String[] PROP_ALL = new String[]{"path", "url", "repouuid", "revision", "nodekind", "schedule", "author", "lastRevision", "lastDate", "name", "lastTextUpdate", "lastPropUpdate", "checksum", "repourl"};
    private String target = null;
    private String property = null;
    private PropRequest request = null;

    public void execute() {
        Project project = this.getProject();
        try {
            ISVNInfo iSVNInfo = this.acquireInfo();
            if (iSVNInfo.getRevision() == null || SVNRevision.INVALID_REVISION.equals((Object)iSVNInfo.getRevision())) {
                throw SingleInfo.ex(MSG_UNVERSIONED_RESOURCE, this.target);
            }
            String string = this.getValue(iSVNInfo, this.request.getValue());
            project.setProperty(this.property, string);
            this.verbose("%s : %s", this.property, string);
        }
        catch (Exception exception) {
            throw SingleInfo.ex(exception, MSG_FAILED_TO_ACCESS_PROPERTIES, new Object[0]);
        }
    }

    private ISVNInfo acquireInfo() throws SVNClientException {
        File file = new File(Project.translatePath((String)this.target));
        if (file.exists()) {
            return this.getClient().getInfo(file);
        }
        try {
            SVNUrl sVNUrl = new SVNUrl(this.target);
            return this.getClient().getInfo(sVNUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return this.getClient().getInfo(file);
        }
    }

    private String getValue(ISVNInfo iSVNInfo, String string) {
        Object object = null;
        if (PROP_PATH.equals(string)) {
            File file = iSVNInfo.getFile();
            object = file != null ? file.getAbsolutePath() : iSVNInfo.getUrl().getLastPathSegment();
        } else if (PROP_NAME.equals(string)) {
            File file = iSVNInfo.getFile();
            object = file != null ? file.getName() : iSVNInfo.getUrl().getLastPathSegment();
        } else if (PROP_REPOURL.equals(string)) {
            object = iSVNInfo.getRepository();
        } else if (PROP_URL.equals(string)) {
            object = iSVNInfo.getUrl();
        } else if (PROP_REPOUUID.equals(string)) {
            object = iSVNInfo.getUuid();
        } else if (PROP_REV.equals(string)) {
            object = iSVNInfo.getRevision();
        } else if (PROP_NODEKIND.equals(string)) {
            object = iSVNInfo.getNodeKind();
        } else if (PROP_SCHEDULE.equals(string)) {
            object = iSVNInfo.getSchedule();
        } else if (PROP_AUTHOR.equals(string)) {
            object = iSVNInfo.getLastCommitAuthor();
        } else if (PROP_LASTREV.equals(string)) {
            object = iSVNInfo.getLastChangedRevision();
        } else if (PROP_LASTDATE.equals(string)) {
            object = iSVNInfo.getLastChangedDate();
        } else if (PROP_LASTTEXTUPDATE.equals(string)) {
            object = iSVNInfo.getLastDateTextUpdate();
        } else if (PROP_LASTPROPUPDATE.equals(string)) {
            object = iSVNInfo.getLastDatePropsUpdate();
        } else if (PROP_CHECKSUM.equals(string)) {
            this.warning("    Property '%s' not implemented", string);
        } else {
            this.warning("    Property '%s' not recognized", string);
        }
        if (object == null) {
            object = "";
        }
        return String.valueOf(object);
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotEmpty("target", this.target);
        SvnAntUtilities.attrNotEmpty("property", this.property);
        SvnAntUtilities.attrNotNull("request", (Object)this.request);
    }

    public void setTarget(String string) {
        this.target = string;
        if (this.target != null && this.target.length() == 0) {
            this.target = null;
        }
    }

    public void setRequest(PropRequest propRequest) {
        this.request = propRequest;
    }

    public void setProperty(String string) {
        this.property = string;
        if (this.property != null && this.property.length() == 0) {
            this.property = null;
        }
    }

    public static class PropRequest
    extends EnumeratedAttribute {
        public String[] getValues() {
            return PROP_ALL;
        }
    }
}

