/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Propget
extends SvnCommand {
    private static final String MSG_CANT_WRITE_PROPERTY = "Can't write property value to file %s";
    private static final String MSG_CANT_GET_PROPERTY = "Can't get property %s";
    private File path;
    private SVNUrl url;
    private String name;
    private String property;
    private File file;

    public void execute() {
        ISVNProperty iSVNProperty;
        try {
            iSVNProperty = this.path != null ? this.getClient().propertyGet(this.path, this.name) : this.getClient().propertyGet(this.url, this.name);
        }
        catch (SVNClientException sVNClientException) {
            throw Propget.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_PROPERTY, this.name);
        }
        if (this.property != null && iSVNProperty != null) {
            this.getProject().setProperty(this.property, iSVNProperty.getValue());
        }
        if (this.file != null) {
            FileOutputStream fileOutputStream;
            block8: {
                fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.file);
                    if (iSVNProperty == null) break block8;
                    fileOutputStream.write(iSVNProperty.getData());
                }
                catch (IOException iOException) {
                    try {
                        throw Propget.ex(iOException, MSG_CANT_WRITE_PROPERTY, this.file.toString());
                    }
                    catch (Throwable throwable) {
                        SvnAntUtilities.close(fileOutputStream);
                        throw throwable;
                    }
                }
            }
            SvnAntUtilities.close(fileOutputStream);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("path, url", true, new Object[]{this.path, this.url});
        SvnAntUtilities.attrNotEmpty("name", this.name);
        SvnAntUtilities.attrsNotSet("property, file", this.property, this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setName(String string) {
        this.name = string;
    }
}

