/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Move
extends SvnCommand {
    private static final String MSG_CANT_COPY = "Can't copy";
    private File srcPath = null;
    private File destPath = null;
    private SVNUrl srcUrl = null;
    private SVNUrl destUrl = null;
    private String message = null;
    private boolean force = false;

    public void execute() {
        if (this.srcPath != null) {
            try {
                this.getClient().move(this.srcPath, this.destPath, this.force);
            }
            catch (SVNClientException sVNClientException) {
                throw Move.ex((Exception)((Object)sVNClientException), MSG_CANT_COPY, new Object[0]);
            }
        }
        try {
            this.getClient().move(this.srcUrl, this.destUrl, this.message, SVNRevision.HEAD);
        }
        catch (SVNClientException sVNClientException) {
            throw Move.ex((Exception)((Object)sVNClientException), MSG_CANT_COPY, new Object[0]);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("srcPath, srcUrl", true, new Object[]{this.srcPath, this.srcUrl});
        if (this.srcPath != null) {
            SvnAntUtilities.attrNotNull("destPath", this.destPath);
            SvnAntUtilities.attrNull("destUrl", this.destUrl);
        }
        if (this.srcUrl != null) {
            SvnAntUtilities.attrNotNull("destUrl", this.destUrl);
            SvnAntUtilities.attrNull("destPath", this.destPath);
            SvnAntUtilities.attrNotEmpty("message", this.message);
        }
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setDestUrl(SVNUrl sVNUrl) {
        this.destUrl = sVNUrl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

