/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Log
extends SvnCommand {
    private static final String MSG_FAILED_TO_LOAD = "Can't get the content of the specified file";
    private static final String MSG_CANT_GET_LOG_MESSAGES = "Can't get the log messages for the path or url";
    private File destFile = null;
    private SVNUrl url = null;
    private File path = null;
    private boolean stopOnCopy = true;
    private boolean asXml = true;
    private long limit = 0L;
    private SVNRevision startRevision = SVNRevision.HEAD;
    private SVNRevision stopRevision = new SVNRevision.Number(1L);
    private boolean changedpathes = false;

    public void execute() {
        if (this.destFile == null) {
            this.destFile = new File(this.getProject().getBaseDir(), this.url.getLastPathSegment());
        }
        ISVNLogMessage[] iSVNLogMessageArray = null;
        try {
            iSVNLogMessageArray = this.path != null ? this.getClient().getLogMessages(this.path, this.startRevision, this.stopRevision, this.stopOnCopy, this.changedpathes, this.limit) : this.getClient().getLogMessages(this.url, this.startRevision, this.startRevision, this.stopRevision, this.stopOnCopy, this.changedpathes, this.limit);
            this.writeLogMessages(iSVNLogMessageArray);
        }
        catch (SVNClientException sVNClientException) {
            throw Log.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_LOG_MESSAGES, new Object[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeLogMessages(ISVNLogMessage[] iSVNLogMessageArray) {
        if (this.asXml) {
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.destFile));
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                document.setXmlStandalone(true);
                Element element = document.createElement("log");
                document.appendChild(element);
                for (ISVNLogMessage iSVNLogMessage : iSVNLogMessageArray) {
                    this.writeLogEntryAsXml(iSVNLogMessage, document, element);
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(bufferedOutputStream));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                try {
                    throw Log.ex(transformerConfigurationException, MSG_FAILED_TO_LOAD, new Object[0]);
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw Log.ex(parserConfigurationException, MSG_FAILED_TO_LOAD, new Object[0]);
                    }
                    catch (TransformerException transformerException) {
                        throw Log.ex(transformerException, MSG_FAILED_TO_LOAD, new Object[0]);
                    }
                    catch (IOException iOException) {
                        throw Log.ex(iOException, MSG_FAILED_TO_LOAD, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    SvnAntUtilities.close(bufferedOutputStream);
                    throw throwable;
                }
            }
            SvnAntUtilities.close(bufferedOutputStream);
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.destFile)));
            for (int i = 0; i < iSVNLogMessageArray.length; ++i) {
                this.writeLogEntryAsPlaintext(iSVNLogMessageArray[i], bufferedWriter);
            }
        }
        catch (IOException iOException) {
            try {
                throw Log.ex(iOException, MSG_FAILED_TO_LOAD, new Object[0]);
            }
            catch (Throwable throwable) {
                SvnAntUtilities.close(bufferedWriter);
                throw throwable;
            }
        }
        SvnAntUtilities.close(bufferedWriter);
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("url, path", this.url, this.path);
        SvnAntUtilities.attrNotNull("startRevision", this.startRevision);
        SvnAntUtilities.attrNotNull("stopRevision", this.stopRevision);
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public void setStartRevision(String string) {
        this.startRevision = this.getRevisionFrom(string);
    }

    public void setStopRevision(String string) {
        this.stopRevision = this.getRevisionFrom(string);
    }

    public void setStopOnCopy(boolean bl) {
        this.stopOnCopy = bl;
    }

    public void setAsXml(boolean bl) {
        this.asXml = bl;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setChangedpathes(boolean bl) {
        this.changedpathes = bl;
    }

    private void writeLogEntryAsPlaintext(ISVNLogMessage iSVNLogMessage, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("------------------------------------------------------------------------");
        bufferedWriter.newLine();
        bufferedWriter.write(114);
        bufferedWriter.write(iSVNLogMessage.getRevision().toString());
        bufferedWriter.write(" | ");
        bufferedWriter.write(iSVNLogMessage.getAuthor());
        bufferedWriter.write(" | ");
        bufferedWriter.write(iSVNLogMessage.getDate().toString());
        if (this.changedpathes) {
            bufferedWriter.write("Changed paths:");
            bufferedWriter.newLine();
            for (ISVNLogMessageChangePath iSVNLogMessageChangePath : iSVNLogMessage.getChangedPaths()) {
                bufferedWriter.write("   " + iSVNLogMessageChangePath.getAction() + " ");
                bufferedWriter.write(iSVNLogMessageChangePath.getPath());
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write(iSVNLogMessage.getMessage());
        bufferedWriter.newLine();
    }

    private void writeLogEntryAsXml(ISVNLogMessage iSVNLogMessage, Document document, Element element) {
        Element element2;
        Element element3 = document.createElement("logentry");
        element3.setAttribute("revision", iSVNLogMessage.getRevision().toString());
        element.appendChild(element3);
        Element element4 = document.createElement("author");
        element3.appendChild(element4);
        Text text = document.createTextNode(iSVNLogMessage.getAuthor());
        element4.appendChild(text);
        Element element5 = document.createElement("date");
        element3.appendChild(element5);
        Text text2 = document.createTextNode(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(iSVNLogMessage.getDate()));
        element5.appendChild(text2);
        if (this.changedpathes) {
            element2 = document.createElement("paths");
            element3.appendChild(element2);
            for (ISVNLogMessageChangePath iSVNLogMessageChangePath : iSVNLogMessage.getChangedPaths()) {
                Element element6 = document.createElement("path");
                element2.appendChild(element6);
                element6.setAttribute("action", String.valueOf(iSVNLogMessageChangePath.getAction()));
                Text text3 = document.createTextNode(iSVNLogMessageChangePath.getPath());
                element6.appendChild(text3);
            }
        }
        element2 = document.createElement("msg");
        element3.appendChild(element2);
        Text text4 = document.createTextNode(iSVNLogMessage.getMessage());
        element2.appendChild(text4);
    }
}

