/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class List
extends SvnCommand {
    private static final String MSG_CANT_LIST = "Can't list";
    private SVNUrl url = null;
    private boolean recurse = false;
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean onlynames = false;
    private String delimiter = ",";
    private boolean listFiles = true;
    private boolean listDirs = true;
    private String property;

    public void execute() {
        try {
            ISVNDirEntry[] iSVNDirEntryArray = this.getClient().getList(this.url, this.revision, this.recurse);
            int n = 0;
            for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
                if (iSVNDirEntryArray[i].getNodeKind() == SVNNodeKind.DIR) {
                    if (this.listDirs) continue;
                    iSVNDirEntryArray[i] = null;
                    ++n;
                    continue;
                }
                if (iSVNDirEntryArray[i].getNodeKind() == SVNNodeKind.FILE) {
                    if (this.listFiles) continue;
                    iSVNDirEntryArray[i] = null;
                    ++n;
                    continue;
                }
                iSVNDirEntryArray[i] = null;
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n < iSVNDirEntryArray.length) {
                int n2 = 0;
                for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
                    if (iSVNDirEntryArray[i] == null) continue;
                    if (n2 > 0) {
                        stringBuffer.append(this.delimiter);
                    }
                    String string = iSVNDirEntryArray[i].getPath();
                    if (!this.onlynames) {
                        string = this.url.appendPath(string).toString();
                    }
                    stringBuffer.append(string);
                    ++n2;
                }
            }
            this.getProject().setProperty(this.property, stringBuffer.toString());
        }
        catch (SVNClientException sVNClientException) {
            throw List.ex((Exception)((Object)sVNClientException), MSG_CANT_LIST, new Object[0]);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("url", this.url);
        SvnAntUtilities.attrNotNull("revision", this.revision);
        SvnAntUtilities.attrNotEmpty("delimiter", this.delimiter);
        SvnAntUtilities.attrNotEmpty("property", this.property);
    }

    public void setListFiles(boolean bl) {
        this.listFiles = bl;
    }

    public void setListDirs(boolean bl) {
        this.listDirs = bl;
    }

    public void setOnlyNames(boolean bl) {
        this.onlynames = bl;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

