/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.apache.tools.ant.Project;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Info
extends SvnCommand {
    private static final String MSG_FAILED_TO_SET_INFO_PROPS = "Failed to set 'info' properties";
    private static final String MSG_UNSUPPORTED_OPTION = "The attribute 'verbose' is no longer supported for the command 'info' as it's generally enabled using the Ant option -v !";
    private String target = null;
    private String propPrefix = "svn.info.";
    private ISVNInfo info = null;
    private static final String[] DIR_PROP_NAMES = new String[]{"path", "url", "repourl", "repouuid", "rev", "nodekind", "schedule", "author", "lastRev", "lastDate"};
    private static final String[] FILE_PROP_NAMES = new String[]{"path", "name", "url", "repourl", "repouuid", "rev", "nodekind", "schedule", "author", "lastRev", "lastDate", "lastTextUpdate", "lastPropUpdate", "checksum"};

    public void execute() {
        Project project = this.getProject();
        try {
            this.info = this.acquireInfo();
            if (this.info.getRevision() == null || SVNRevision.INVALID_REVISION.equals((Object)this.info.getRevision())) {
                throw Info.ex("%s - Not a versioned resource", this.target);
            }
            String[] stringArray = SVNNodeKind.DIR == this.info.getNodeKind() ? DIR_PROP_NAMES : FILE_PROP_NAMES;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.getValue(stringArray[i]);
                project.setProperty(this.propPrefix + stringArray[i], string);
                this.verbose("%s%s: %s", this.propPrefix, stringArray[i], string);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Info.ex((Exception)((Object)sVNClientException), MSG_FAILED_TO_SET_INFO_PROPS, new Object[0]);
        }
    }

    private ISVNInfo acquireInfo() throws SVNClientException {
        File file = new File(Project.translatePath((String)this.target));
        if (file.exists()) {
            return this.getClient().getInfo(file);
        }
        try {
            SVNUrl sVNUrl = new SVNUrl(this.target);
            return this.getClient().getInfo(sVNUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return this.getClient().getInfo(file);
        }
    }

    public String getValue(String string) {
        Object object = null;
        if (FILE_PROP_NAMES[0].equals(string)) {
            object = this.info.getFile();
            object = object != null ? ((File)object).getAbsolutePath() : this.info.getUrl().getLastPathSegment();
        } else if (FILE_PROP_NAMES[1].equals(string)) {
            object = this.info.getFile();
            object = object != null ? ((File)object).getName() : this.info.getUrl().getLastPathSegment();
        } else if (FILE_PROP_NAMES[2].equals(string)) {
            object = this.info.getUrl();
        } else if (FILE_PROP_NAMES[3].equals(string)) {
            object = this.info.getRepository();
        } else if (FILE_PROP_NAMES[4].equals(string)) {
            object = this.info.getUuid();
        } else if (FILE_PROP_NAMES[5].equals(string)) {
            object = this.info.getRevision();
        } else if (FILE_PROP_NAMES[6].equals(string)) {
            object = this.info.getNodeKind();
        } else if (FILE_PROP_NAMES[7].equals(string)) {
            object = this.info.getSchedule();
        } else if (FILE_PROP_NAMES[8].equals(string)) {
            object = this.info.getLastCommitAuthor();
        } else if (FILE_PROP_NAMES[9].equals(string)) {
            object = this.info.getLastChangedRevision();
        } else if (FILE_PROP_NAMES[10].equals(string)) {
            Date date = this.info.getLastChangedDate();
            if (date != null) {
                object = this.getDateStringFor(date);
            }
        } else if (FILE_PROP_NAMES[11].equals(string)) {
            Date date = this.info.getLastDateTextUpdate();
            if (date != null) {
                object = this.getDateStringFor(date);
            }
        } else if (FILE_PROP_NAMES[12].equals(string)) {
            Date date = this.info.getLastDatePropsUpdate();
            if (date != null) {
                object = this.getDateStringFor(date);
            }
        } else if (FILE_PROP_NAMES[13].equals(string)) {
            this.warning("    Property '%s' not implemented", string);
        } else {
            this.warning("    Property '%s' not recognized", string);
        }
        return object == null ? "" : object.toString();
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("target", this.target);
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setVerbose(boolean bl) {
        this.warning(MSG_UNSUPPORTED_OPTION, new Object[0]);
    }

    public void setPropPrefix(String string) {
        this.propPrefix = string.endsWith(".") ? string : string + '.';
    }
}

