/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Import
extends SvnCommand {
    private static final String MSG_CANT_IMPORT = "Can't import";
    private static final String MSG_CANT_MAKE_DIR = "Can't make dir %s";
    private SVNUrl url = null;
    private File path = null;
    private String message = null;
    private boolean recurse = true;
    private String newentry = null;

    public void execute() {
        try {
            SVNUrl sVNUrl = this.url;
            if (this.newentry != null) {
                try {
                    sVNUrl = this.url.appendPath(this.newentry);
                    this.getClient().mkdir(sVNUrl, this.message);
                }
                catch (SVNClientException sVNClientException) {
                    throw Import.ex((Exception)((Object)sVNClientException), MSG_CANT_MAKE_DIR, this.url);
                }
            }
            this.getClient().doImport(this.path, sVNUrl, this.message, this.recurse);
        }
        catch (SVNClientException sVNClientException) {
            throw Import.ex((Exception)((Object)sVNClientException), MSG_CANT_IMPORT, new Object[0]);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("url", this.url);
        SvnAntUtilities.attrNotNull("path", this.path);
        SvnAntUtilities.attrNotEmpty("message", this.message);
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setNewEntry(String string) {
        this.newentry = string;
        if (this.newentry != null && this.newentry.trim().length() == 0) {
            this.newentry = null;
        }
    }
}

