/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileFilter;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Ignore
extends SvnCommand
implements FileFilter {
    private static final String MSG_CANT_ADD_FILE = "Can't add file %s to svn:ignore";
    private static final String MSG_CANT_ADD_PATTERN = "Can't add pattern %s to svn:ignore for %s";
    private File file = null;
    private File dir = null;
    private boolean recurse = false;
    private String pattern;

    public void execute() {
        if (this.file != null) {
            this.svnIgnoreFile(this.file);
        }
        if (this.dir != null) {
            this.svnIgnorePattern(this.dir, this.recurse);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("file, dir", true, new Object[]{this.file, this.dir});
        if (this.dir != null) {
            SvnAntUtilities.attrIsDirectory("dir", this.dir);
            SvnAntUtilities.attrNotNull("pattern", this.pattern);
        }
        if (this.file != null) {
            SvnAntUtilities.attrIsFile("file", this.file);
            SvnAntUtilities.attrNull("pattern", this.pattern);
        }
    }

    private void svnIgnoreFile(File file) {
        try {
            this.getClient().addToIgnoredPatterns(file.getParentFile(), file.getName());
        }
        catch (SVNClientException sVNClientException) {
            throw Ignore.ex((Exception)((Object)sVNClientException), MSG_CANT_ADD_FILE, file.getAbsolutePath());
        }
    }

    private void svnIgnorePattern(File file, boolean bl) {
        this.svnIgnorePattern(file);
        if (bl) {
            File[] fileArray = file.listFiles(this);
            for (int i = 0; i < fileArray.length; ++i) {
                this.svnIgnorePattern(fileArray[i], true);
            }
        }
    }

    public boolean accept(File file) {
        return file.isDirectory() && !file.getName().equals(this.getClient().getAdminDirectoryName());
    }

    private void svnIgnorePattern(File file) {
        try {
            this.getClient().addToIgnoredPatterns(file, this.pattern);
        }
        catch (SVNClientException sVNClientException) {
            throw Ignore.ex((Exception)((Object)sVNClientException), MSG_CANT_ADD_PATTERN, this.pattern, file.getAbsolutePath());
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }
}

