/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Export
extends SvnCommand {
    private static final String MSG_CANT_EXPORT = "Can't export";
    private boolean force = false;
    private SVNUrl srcUrl = null;
    private File srcPath = null;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute() {
        try {
            if (this.srcUrl != null) {
                this.getClient().doExport(this.srcUrl, this.destPath, this.revision, this.force);
            } else {
                this.getClient().doExport(this.srcPath, this.destPath, this.force);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Export.ex((Exception)((Object)sVNClientException), MSG_CANT_EXPORT, new Object[0]);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("destPath", this.destPath);
        SvnAntUtilities.attrNotNull("revision", this.revision);
        SvnAntUtilities.attrsNotSet("srcUrl, srcPath", true, new Object[]{this.srcUrl, this.srcPath});
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

