/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.Diff;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;

public class DiffSummarize
extends Diff {
    private int depth = 1000;
    private boolean ignoreAncestry = true;
    private boolean logToFile = false;
    private String encoding = "UTF-8";

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOutFile(File file) {
        super.setOutFile(file);
        this.logToFile = true;
    }

    public void setAncestry(boolean bl) {
        this.ignoreAncestry = !bl;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        SVNDiffSummary[] sVNDiffSummaryArray;
        BufferedWriter bufferedWriter = null;
        if (this.logToFile) {
            sVNDiffSummaryArray = this.getOutFile();
            try {
                this.log("output to file: " + sVNDiffSummaryArray);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)sVNDiffSummaryArray), this.encoding));
            }
            catch (IOException iOException) {
                throw DiffSummarize.ex(iOException, iOException.getMessage(), new Object[0]);
            }
        }
        try {
            this.logAction(true);
            sVNDiffSummaryArray = this.getClient().diffSummarize(this.getOldUrl(), this.getOldTargetRevision(), this.getNewUrl(), this.getNewTargetRevision(), this.depth, this.ignoreAncestry);
            StringBuilder stringBuilder = new StringBuilder();
            for (SVNDiffSummary sVNDiffSummary : sVNDiffSummaryArray) {
                stringBuilder.setLength(0);
                char c = Character.toUpperCase(sVNDiffSummary.getDiffKind().toString().charAt(0));
                if (c != 'A' && c != 'M' && c != 'D') {
                    this.warning("the diff kind '%s' is currently not known", Character.valueOf(c));
                }
                stringBuilder.append(sVNDiffSummary.propsChanged() ? "M" : " ");
                stringBuilder.append(" ");
                stringBuilder.append(sVNDiffSummary.getPath());
                if (this.logToFile) {
                    stringBuilder.append("\n");
                    bufferedWriter.write(stringBuilder.toString());
                    continue;
                }
                this.log(stringBuilder.toString());
            }
        }
        catch (SVNClientException sVNClientException) {
            try {
                throw new BuildException((Throwable)sVNClientException);
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                SvnAntUtilities.close(bufferedWriter);
                throw throwable;
            }
        }
        SvnAntUtilities.close(bufferedWriter);
    }

    protected void validateAttributes() {
        super.validateAttributes();
        SvnAntUtilities.attrNotEmpty("encoding", this.encoding);
    }
}

