/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Diff
extends SvnCommand {
    private static final String MSG_CANT_GET_DIFFERENCES = "Can't get the differences";
    private static final String MSG_INVALID_PATH_URL_MIXUP = "paths cannot be with urls when diffing";
    private SVNUrl oldUrl = null;
    private SVNUrl newUrl = null;
    private File oldPath = null;
    private File newPath = null;
    private SVNRevision oldTargetRevision = null;
    private SVNRevision newTargetRevision = null;
    private File outFile = new File("patch");
    private boolean recurse = true;

    public void execute() {
        try {
            if (this.oldUrl != null) {
                this.getClient().diff(this.oldUrl, this.oldTargetRevision, this.newUrl, this.newTargetRevision, this.outFile, this.recurse);
            } else {
                this.getClient().diff(this.oldPath, this.oldTargetRevision, this.newPath, this.newTargetRevision, this.outFile, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Diff.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_DIFFERENCES, new Object[0]);
        }
    }

    protected void validateAttributes() {
        if (this.oldUrl != null ? this.oldPath != null || this.newPath != null : this.oldUrl != null || this.newUrl != null) {
            throw Diff.ex(MSG_INVALID_PATH_URL_MIXUP, new Object[0]);
        }
    }

    public void setNewPath(File file) {
        this.newPath = file;
    }

    public void setNewTargetRevision(String string) {
        this.newTargetRevision = this.getRevisionFrom(string);
    }

    protected SVNRevision getNewTargetRevision() {
        return this.newTargetRevision;
    }

    public void setNewUrl(SVNUrl sVNUrl) {
        this.newUrl = sVNUrl;
    }

    protected SVNUrl getNewUrl() {
        return this.newUrl;
    }

    public void setOldPath(File file) {
        this.oldPath = file;
    }

    public void setOldTargetRevision(String string) {
        this.oldTargetRevision = this.getRevisionFrom(string);
    }

    protected SVNRevision getOldTargetRevision() {
        return this.oldTargetRevision;
    }

    public void setOldUrl(SVNUrl sVNUrl) {
        this.oldUrl = sVNUrl;
    }

    protected SVNUrl getOldUrl() {
        return this.oldUrl;
    }

    public void setOutFile(File file) {
        this.outFile = file;
    }

    protected File getOutFile() {
        return this.outFile;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    protected void logAction(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("# diff ");
        stringBuilder.append(bl ? this.oldUrl : this.oldPath);
        stringBuilder.append(" ");
        stringBuilder.append(this.oldTargetRevision);
        this.log(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("#      ");
        stringBuilder.append(bl ? this.newUrl : this.newPath);
        stringBuilder.append(" ");
        stringBuilder.append(this.newTargetRevision);
        this.log(stringBuilder.toString());
        if (this.outFile != null) {
            this.log("# to outfile: " + this.outFile.getAbsolutePath());
        }
    }
}

