/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.ResourceSetSvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Delete
extends ResourceSetSvnCommand {
    private static final String MSG_CANNOT_DELETE = "Cannot delete file or directory '%s' !";
    private static final String MSG_CANNOT_DELETE_URL = "Cannot delete url '%s'";
    private String message = null;
    private SVNUrl url = null;
    private boolean force = false;

    public Delete() {
        super(true, true);
    }

    protected void handleDir(File file, boolean bl) {
        this.deleteFile(file, this.force);
    }

    protected void handleFile(File file) {
        this.deleteFile(file, this.force);
    }

    protected void handleBegin() {
        if (this.url != null) {
            this.deleteUrl(this.url, this.message);
        }
    }

    protected void validateAttributes() {
        if (this.url == null) {
            super.validateAttributes();
        } else {
            SvnAntUtilities.attrNotEmpty("message", this.message);
        }
    }

    private void deleteUrl(SVNUrl sVNUrl, String string) {
        try {
            this.getClient().remove(new SVNUrl[]{sVNUrl}, string);
        }
        catch (SVNClientException sVNClientException) {
            throw Delete.ex((Exception)((Object)sVNClientException), MSG_CANNOT_DELETE_URL, sVNUrl.toString());
        }
    }

    private void deleteFile(File file, boolean bl) {
        try {
            this.getClient().remove(new File[]{file}, bl);
        }
        catch (SVNClientException sVNClientException) {
            throw Delete.ex((Exception)((Object)sVNClientException), MSG_CANNOT_DELETE, file.getAbsolutePath());
        }
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

