/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Copy
extends SvnCommand {
    private static final String MSG_CANT_COPY = "Can't copy";
    private File srcPath = null;
    private File destPath = null;
    private SVNUrl srcUrl = null;
    private SVNUrl destUrl = null;
    private boolean makeparents = false;
    private SVNRevision revision = SVNRevision.HEAD;
    private String message = null;

    public void execute() {
        try {
            if (this.srcPath != null) {
                if (this.destPath != null) {
                    this.getClient().copy(this.srcPath, this.destPath);
                } else {
                    this.getClient().copy(this.srcPath, this.destUrl, this.message);
                }
            } else if (this.destPath != null) {
                this.getClient().copy(this.srcUrl, this.destPath, this.revision);
            } else {
                this.getClient().copy(this.srcUrl, this.destUrl, this.message, this.revision, this.makeparents);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Copy.ex((Exception)((Object)sVNClientException), MSG_CANT_COPY, new Object[0]);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("srcPath, srcUrl", true, new Object[]{this.srcPath, this.srcUrl});
        SvnAntUtilities.attrsNotSet("destPath, destUrl", true, new Object[]{this.destPath, this.destUrl});
        SvnAntUtilities.attrNotNull("revision", this.revision);
        if (this.destUrl != null) {
            SvnAntUtilities.attrNotEmpty("message", this.message);
        }
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setDestUrl(SVNUrl sVNUrl) {
        this.destUrl = sVNUrl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setMakeParents(boolean bl) {
        this.makeparents = bl;
    }
}

