/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Checkout
extends SvnCommand {
    private static final String MSG_CHECKOUT_FAILED = "Can't checkout";
    private static final String MSG_USAGE_CONFLICT = "The option 'recurse' cannot be used together with 'depth' ! Ignoring 'recurse' !";
    private SVNUrl url = null;
    private Boolean recurse = null;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean force = false;
    private boolean ignoreexternals = false;
    private CheckoutDepth depth = null;

    public void execute() {
        if (this.destPath == null) {
            this.destPath = this.getProject().getBaseDir();
        }
        try {
            if (this.depth != null) {
                this.getClient().checkout(this.url, this.destPath, this.revision, this.depth.getIntValue(), this.ignoreexternals, this.force);
            } else {
                this.getClient().checkout(this.url, this.destPath, this.revision, this.recurse == null ? true : this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Checkout.ex((Exception)((Object)sVNClientException), MSG_CHECKOUT_FAILED, new Object[0]);
        }
    }

    protected void validateAttributes() {
        if (this.destPath != null) {
            SvnAntUtilities.attrNotNull("destpath", this.destPath);
        }
        SvnAntUtilities.attrNotNull("url", this.url);
        SvnAntUtilities.attrNotNull("revision", this.revision);
        if (this.depth != null && this.recurse != null) {
            this.warning(MSG_USAGE_CONFLICT, new Object[0]);
        }
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setIgnoreExternals(boolean bl) {
        this.ignoreexternals = bl;
    }

    public void setDepth(CheckoutDepth checkoutDepth) {
        this.depth = checkoutDepth;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setDestpath(File file) {
        this.destPath = file;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public static class CheckoutDepth
    extends EnumeratedAttribute {
        private static final String MSG_UNSUPPORTED_DEPTH_VALUE = "Unsupported 'depth' value: '%s'";
        private static final String[] VALUES = new String[]{"empty", "files", "immediates", "infinity"};
        private static final int[] IVALUES = new int[]{0, 1, 2, 3};

        public String[] getValues() {
            return VALUES;
        }

        public int getIntValue() {
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].equalsIgnoreCase(this.getValue())) continue;
                return IVALUES[i];
            }
            throw SvnCommand.ex(MSG_UNSUPPORTED_DEPTH_VALUE, this.getValue());
        }
    }
}

