/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Cat
extends SvnCommand {
    private static final String MSG_CANT_GET_CONTENT = "Can't get the content of %s";
    private SVNUrl url = null;
    private File destFile = null;
    private SVNRevision revision = SVNRevision.HEAD;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (this.destFile == null) {
            this.destFile = new File(this.getProject().getBaseDir(), this.url.getLastPathSegment());
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.destFile);
            inputStream = this.getClient().getContent(this.url, this.revision);
            byte[] byArray = new byte[5000];
            int n = inputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            try {
                throw Cat.ex(iOException, MSG_CANT_GET_CONTENT, this.url);
                catch (SVNClientException sVNClientException) {
                    throw Cat.ex((Exception)((Object)sVNClientException), MSG_CANT_GET_CONTENT, this.url);
                }
            }
            catch (Throwable throwable) {
                SvnAntUtilities.close(fileOutputStream);
                SvnAntUtilities.close(inputStream);
                throw throwable;
            }
        }
        SvnAntUtilities.close(fileOutputStream);
        SvnAntUtilities.close(inputStream);
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("url", this.url);
        if (this.destFile != null) {
            SvnAntUtilities.attrCanWrite("destFile", this.destFile);
        }
        SvnAntUtilities.attrNotNull("revision", this.revision);
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }
}

