/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.commands.ResourceSetSvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Add
extends ResourceSetSvnCommand {
    private static final String MSG_CANT_ADD_DIRECTORY = "Can't add directory '%s' to repository";
    private static final String MSG_CANT_ADD_FILE = "Can't add file '%s' to repository";
    private boolean force = false;

    public Add() {
        super(true, false, true, null);
    }

    protected void handleUnmanaged(File file) {
        this.svnAddDir(file, false, this.force);
    }

    protected void handleDir(File file, boolean bl) {
        this.svnAddDir(file, bl, this.force);
    }

    protected void handleFile(File file) {
        this.svnAddFile(file);
    }

    private void svnAddFile(File file) {
        try {
            this.getClient().addFile(file);
        }
        catch (SVNClientException sVNClientException) {
            throw Add.ex((Exception)((Object)sVNClientException), MSG_CANT_ADD_FILE, file);
        }
    }

    private void svnAddDir(File file, boolean bl, boolean bl2) {
        try {
            this.getClient().addDirectory(file, bl, bl2);
        }
        catch (SVNClientException sVNClientException) {
            throw Add.ex((Exception)((Object)sVNClientException), MSG_CANT_ADD_DIRECTORY, file);
        }
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setRecurse(boolean bl) {
        super.setRecurse(bl);
    }
}

