/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.tools.ant.BuildException;

public class SvnAntUtilities {
    private SvnAntUtilities() {
    }

    public static final void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void attrsNotSet(String string, Object ... objectArray) {
        SvnAntUtilities.attrsNotSet(string, false, objectArray);
    }

    public static final void attrsNotSet(String string, boolean bl, Object ... objectArray) {
        int n = 0;
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object instanceof Collection) {
                    if (((Collection)object).size() <= 0) continue;
                    ++n;
                    continue;
                }
                if (object == null) continue;
                ++n;
            }
        }
        if (n == 0) {
            throw SvnAntUtilities.create("At least one value of {%s} has to be set.", string);
        }
        if (bl && n > 1) {
            throw SvnAntUtilities.create("Only one value of {%s} is allowed to be set.", string);
        }
    }

    public static final void attrNotNull(String string, Object object) {
        if (object == null) {
            throw SvnAntUtilities.create("The attribute '%s' has not been set.", string);
        }
    }

    public static final void attrNull(String string, Object object) {
        if (object != null) {
            throw SvnAntUtilities.create("The attribute '%s' is not allowed to be set.", string);
        }
    }

    public static final void attrIsFile(String string, File file) {
        SvnAntUtilities.attrNotNull(string, file);
        if (!file.isFile()) {
            throw SvnAntUtilities.create("The attribute '%s' with the value '%s' is not a file.", string, file);
        }
    }

    public static final void attrExists(String string, File file) {
        SvnAntUtilities.attrNotNull(string, file);
        if (!file.exists()) {
            throw SvnAntUtilities.create("The attribute '%s' with the value '%s' doesn't denote an existing resource.", string, file);
        }
    }

    public static final void attrIsDirectory(String string, File file) {
        SvnAntUtilities.attrNotNull(string, file);
        if (!file.isDirectory()) {
            throw SvnAntUtilities.create("The attribute '%s' with the value '%s' is not a directory.", string, file);
        }
    }

    public static final void attrCanWrite(String string, File file) {
        SvnAntUtilities.attrNotNull(string, file);
        if (file.exists() && (file.isDirectory() || !file.canWrite())) {
            throw SvnAntUtilities.create("The attribute '%s' which denotes the file '%s' doesn't specify a writable file.", string, file);
        }
    }

    public static final void attrNotEmpty(String string, String string2) {
        SvnAntUtilities.attrNotNull(string, string2);
        if (string2.length() == 0) {
            throw SvnAntUtilities.create("The attribute '%s' is neither allowed to be null nor empty.", string);
        }
    }

    public static final void attrInvalidValue(String string, Object[] objectArray, String string2) {
        SvnAntUtilities.attrNotNull(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : objectArray) {
            if (string2.equals(String.valueOf(object))) {
                return;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(object));
        }
        throw SvnAntUtilities.create("The attribute '%s' has the value '%s' but only the following values are allowed: {%s}.", string, string2, stringBuffer);
    }

    private static final BuildException create(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new BuildException(string);
        }
        Object object = objectArray[objectArray.length - 1];
        if (object instanceof Exception) {
            return new BuildException(String.format(string, objectArray), (Throwable)((Exception)object));
        }
        return new BuildException(String.format(string, objectArray));
    }
}

