/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.jcache.JCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheManager
extends CacheManager {
    protected static JCacheManager singleton;
    private static final Logger LOG;
    protected Map jCaches = new HashMap();

    public JCacheManager(Configuration configuration) throws CacheException {
        super(configuration);
    }

    public JCacheManager(String configurationFileName) throws CacheException {
        super(configurationFileName);
    }

    public JCacheManager(URL configurationURL) throws CacheException {
        super(configurationURL);
    }

    public JCacheManager(InputStream configurationInputStream) throws CacheException {
        super(configurationInputStream);
    }

    public JCacheManager() throws CacheException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCacheManager create() throws CacheException {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with default config");
                }
                singleton = new JCacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to create an existing singleton. Existing singleton returned.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static JCacheManager getInstance() throws CacheException {
        return JCacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCacheManager create(String configurationFileName) throws CacheException {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with config file: " + configurationFileName);
                }
                singleton = new JCacheManager(configurationFileName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCacheManager create(URL configurationFileURL) throws CacheException {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with config URL: " + configurationFileURL);
                }
                singleton = new JCacheManager(configurationFileURL);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCacheManager create(InputStream inputStream) throws CacheException {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with InputStream");
                }
                singleton = new JCacheManager(inputStream);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public synchronized JCache getJCache(String name) throws IllegalStateException {
        this.checkStatus();
        if (this.jCaches.get(name) != null) {
            return (JCache)this.jCaches.get(name);
        }
        if (this.ehcaches.get(name) != null) {
            this.jCaches.put(name, new JCache((Ehcache)this.ehcaches.get(name)));
        }
        return (JCache)this.jCaches.get(name);
    }

    public synchronized void addCache(JCache jCache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (jCache == null) {
            return;
        }
        Ehcache backingCache = jCache.getBackingCache();
        this.addCache(backingCache);
        this.jCaches.put(backingCache.getName(), jCache);
    }

    public synchronized void replaceEhcacheWithJCache(Ehcache ehcache, JCache jCache) throws CacheException {
        if (!ehcache.getName().equals(jCache.getBackingCache().getName())) {
            throw new CacheException("Cannot replace ehcache with a JCache where the backing cache has a different name");
        }
        Ehcache backingCache = jCache.getBackingCache();
        if (!ehcache.equals(backingCache)) {
            throw new CacheException("Cannot replace " + backingCache.getName() + " It does not equal the incumbent cache.");
        }
        this.jCaches.put(backingCache.getName(), jCache);
    }

    public synchronized void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.ehcaches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            this.cacheManagerEventListenerRegistry.notifyCacheRemoved(cache.getName());
        }
        this.jCaches.remove(cacheName);
        this.caches.remove(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CacheManager already shutdown");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            super.shutdown();
            if (this == singleton) {
                singleton = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(JCacheManager.class);
    }
}

