/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.jcache.JCache;
import net.sf.ehcache.jcache.loader.JCacheLoader;
import net.sf.ehcache.jcache.loader.JCacheLoaderFactory;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheFactory
implements CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheFactory.class);

    public net.sf.jsr107cache.Cache createCache(Map environment) throws net.sf.jsr107cache.CacheException {
        Cache cache;
        JCacheLoader cacheLoader;
        try {
            String name = PropertyUtil.extractAndLogProperty((String)"name", (Map)environment);
            String maxElementsInMemoryString = PropertyUtil.extractAndLogProperty((String)"maxElementsInMemory", (Map)environment);
            int maxElementsInMemory = Integer.parseInt(maxElementsInMemoryString);
            String memoryStoreEvictionPolicyString = PropertyUtil.extractAndLogProperty((String)"memoryStoreEvictionPolicy", (Map)environment);
            MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString((String)memoryStoreEvictionPolicyString);
            String overflowToDiskString = PropertyUtil.extractAndLogProperty((String)"overflowToDisk", (Map)environment);
            boolean overflowToDisk = PropertyUtil.parseBoolean((String)overflowToDiskString);
            String eternalString = PropertyUtil.extractAndLogProperty((String)"eternal", (Map)environment);
            boolean eternal = PropertyUtil.parseBoolean((String)eternalString);
            String timeToLiveSecondsString = PropertyUtil.extractAndLogProperty((String)"timeToLiveSeconds", (Map)environment);
            long timeToLiveSeconds = Long.parseLong(timeToLiveSecondsString);
            String timeToIdleSecondsString = PropertyUtil.extractAndLogProperty((String)"timeToIdleSeconds", (Map)environment);
            long timeToIdleSeconds = Long.parseLong(timeToIdleSecondsString);
            String diskPersistentString = PropertyUtil.extractAndLogProperty((String)"diskPersistentSeconds", (Map)environment);
            boolean diskPersistent = PropertyUtil.parseBoolean((String)diskPersistentString);
            long diskExpiryThreadIntervalSeconds = 0L;
            String diskExpiryThreadIntervalSecondsString = PropertyUtil.extractAndLogProperty((String)"diskExpiryThreadIntervalSeconds", (Map)environment);
            if (diskExpiryThreadIntervalSecondsString != null) {
                diskExpiryThreadIntervalSeconds = Long.parseLong(diskExpiryThreadIntervalSecondsString);
            }
            int maxElementsOnDisk = 0;
            String maxElementsOnDiskString = PropertyUtil.extractAndLogProperty((String)"maxElementsOnDisk", (Map)environment);
            if (maxElementsOnDiskString != null) {
                maxElementsOnDisk = Integer.parseInt(maxElementsOnDiskString);
            }
            cacheLoader = null;
            String cacheLoaderFactoryClassName = PropertyUtil.extractAndLogProperty((String)"cacheLoaderFactoryClassName", (Map)environment);
            if (cacheLoaderFactoryClassName == null) {
                LOG.debug("cacheLoaderFactoryClassName not configured. Skipping...");
            } else {
                JCacheLoaderFactory factory = (JCacheLoaderFactory)((Object)ClassLoaderUtil.createNewInstance((String)cacheLoaderFactoryClassName));
                Properties properties = new Properties();
                for (Object key : environment.keySet()) {
                    properties.put(key, environment.get(key));
                }
                cacheLoader = factory.createCacheLoader(properties);
            }
            cache = new Cache(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, null, null, maxElementsOnDisk);
            CacheManager.getInstance().addCache((Ehcache)cache);
        }
        catch (CacheException e) {
            throw new net.sf.jsr107cache.CacheException(e.getMessage(), (Throwable)e);
        }
        return new JCache((Ehcache)cache, (CacheLoader)cacheLoader);
    }
}

