/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextProviderSupport
implements ResourceBundleTextProvider {
    private Class clazz;
    private LocaleProvider localeProvider;
    private ResourceBundle bundle;

    public TextProviderSupport() {
    }

    public TextProviderSupport(Class clazz, LocaleProvider provider) {
        this.clazz = clazz;
        this.localeProvider = provider;
    }

    public TextProviderSupport(ResourceBundle bundle, LocaleProvider provider) {
        this.bundle = bundle;
        this.localeProvider = provider;
    }

    @Override
    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    @Inject
    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public boolean hasKey(String key) {
        String message = this.clazz != null ? LocalizedTextUtil.findText((Class)this.clazz, (String)key, (Locale)this.getLocale(), null, (Object[])new Object[0]) : LocalizedTextUtil.findText((ResourceBundle)this.bundle, (String)key, (Locale)this.getLocale(), null, (Object[])new Object[0]);
        return message != null;
    }

    @Override
    public String getText(String key) {
        return this.getText(key, key, Collections.emptyList());
    }

    @Override
    public String getText(String key, String defaultValue) {
        return this.getText(key, defaultValue, Collections.emptyList());
    }

    @Override
    public String getText(String key, String defaultValue, String arg) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(arg);
        return this.getText(key, defaultValue, args);
    }

    @Override
    public String getText(String key, List<?> args) {
        return this.getText(key, key, args);
    }

    @Override
    public String getText(String key, String[] args) {
        return this.getText(key, key, args);
    }

    @Override
    public String getText(String key, String defaultValue, List<?> args) {
        Object[] argsArray;
        Object[] objectArray = argsArray = args != null && !((Object)args).equals(Collections.emptyList()) ? args.toArray() : null;
        if (this.clazz != null) {
            return LocalizedTextUtil.findText((Class)this.clazz, (String)key, (Locale)this.getLocale(), (String)defaultValue, (Object[])argsArray);
        }
        return LocalizedTextUtil.findText((ResourceBundle)this.bundle, (String)key, (Locale)this.getLocale(), (String)defaultValue, (Object[])argsArray);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args) {
        if (this.clazz != null) {
            return LocalizedTextUtil.findText((Class)this.clazz, (String)key, (Locale)this.getLocale(), (String)defaultValue, (Object[])args);
        }
        return LocalizedTextUtil.findText((ResourceBundle)this.bundle, (String)key, (Locale)this.getLocale(), (String)defaultValue, (Object[])args);
    }

    @Override
    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        Object[] argsArray = args != null ? args.toArray() : null;
        Locale locale = stack == null ? this.getLocale() : (Locale)stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = this.getLocale();
        }
        if (this.clazz != null) {
            return LocalizedTextUtil.findText((Class)this.clazz, (String)key, (Locale)locale, (String)defaultValue, (Object[])argsArray, (ValueStack)stack);
        }
        return LocalizedTextUtil.findText((ResourceBundle)this.bundle, (String)key, (Locale)locale, (String)defaultValue, (Object[])argsArray, (ValueStack)stack);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        Locale locale = stack == null ? this.getLocale() : (Locale)stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = this.getLocale();
        }
        if (this.clazz != null) {
            return LocalizedTextUtil.findText((Class)this.clazz, (String)key, (Locale)locale, (String)defaultValue, (Object[])args, (ValueStack)stack);
        }
        return LocalizedTextUtil.findText((ResourceBundle)this.bundle, (String)key, (Locale)locale, (String)defaultValue, (Object[])args, (ValueStack)stack);
    }

    @Override
    public ResourceBundle getTexts(String aBundleName) {
        return LocalizedTextUtil.findResourceBundle((String)aBundleName, (Locale)this.getLocale());
    }

    @Override
    public ResourceBundle getTexts() {
        if (this.clazz != null) {
            return this.getTexts(this.clazz.getName());
        }
        return this.bundle;
    }

    private Locale getLocale() {
        return this.localeProvider.getLocale();
    }
}

