/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMTTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(CMTTransaction.class);
    protected final JDBCContext jdbcContext;
    protected final TransactionFactory.Context transactionContext;
    private boolean begun;

    public CMTTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        log.debug("begin");
        boolean synchronization = this.jdbcContext.registerSynchronizationIfPossible();
        if (!synchronization) {
            throw new TransactionException("Could not register synchronization for container transaction");
        }
        this.begun = true;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean flush;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("commit");
        boolean bl = flush = !this.transactionContext.isFlushModeNever() && !this.transactionContext.isFlushBeforeCompletionEnabled();
        if (flush) {
            this.transactionContext.managedFlush();
        }
        this.begun = false;
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug("rollback");
        try {
            this.getTransaction().setRollbackOnly();
        }
        catch (SystemException se) {
            log.error("Could not set transaction to rollback only", (Throwable)se);
            throw new TransactionException("Could not set transaction to rollback only", se);
        }
        this.begun = false;
    }

    public javax.transaction.Transaction getTransaction() throws SystemException {
        return this.transactionContext.getFactory().getTransactionManager().getTransaction();
    }

    public boolean isActive() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.getTransaction().getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 0;
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.getTransaction().getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(status);
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.getTransaction().getStatus();
        }
        catch (SystemException se) {
            log.error("Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", se);
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        try {
            this.getTransaction().registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new TransactionException("Could not register synchronization", e);
        }
    }

    public void setTimeout(int seconds) {
        throw new UnsupportedOperationException("cannot set transaction timeout in CMT");
    }
}

