<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
<#assign sharp = '#'/>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">

<!-- This file was auto-generated by ${gen.class.name} <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>. -->

<mapper namespace="${model.name}">
	<#macro resultColumn c, p>
<#if p.simpleJavaType?starts_with("Upload")>
		<result column="${c}"<#rt/>
<#if p.jdbcType?has_content>
 jdbcType="${p.jdbcType}"<#rt/>
</#if>
 property="${p.name}.data" javaType="[B"/>
		<result column="${c}_LEN" jdbcType="BIGINT" property="${p.name}.dataLength" javaType="java.lang.Long"/>
<#else>
		<result column="${c}"<#rt/>
<#if p.jdbcType?has_content>
 jdbcType="${p.jdbcType}"<#rt/>
</#if>
 property="${p.name}" javaType="${p.nativeJavaType}"/>
</#if>
	</#macro>
	<#macro blobLength>
		<#switch dbtype?upper_case>
		<#case "HSQLDB">
			OCTET_LENGTH<#t/>
			<#break>
		<#default>
			LENGTH<#t/>
			<#break>
		</#switch>
	</#macro>
	<#macro nullValue p>
		<#switch dbtype?upper_case>
		<#case "ORACLE">
			<#switch p.jdbcType!>
			<#case "BLOB">
				TO_BLOB(NULL)<#t/>
				<#break>
			<#case "CLOB">
				TO_CLOB(NULL)<#t/>
				<#break>
			<#default>
				NULL<#t/>
				<#break>
			</#switch>
			<#break>
		<#default>
			NULL<#t/>
			<#break>
		</#switch>
	</#macro>
	<#macro fromWithJoins>
			${model.table} ${model.asTableAlias}
			<#list model.joinConditionList as p>
				${p.joinType?upper_case} JOIN ${p.joinTable} ${p.joinTableAlias!} ON (${p.joinCondition?html})
			</#list>
	</#macro>
	<#macro whereByPrimaryKey>
		<#list model.primaryKeyList as p>
			${model.tableOrAlias}.${p.column} = ${sharp}{${p.name},jdbcType=${p.jdbcType}} <#if p_has_next>AND </#if>
		</#list>
	</#macro>
	<#macro whereByPrimaryKeyU>
		<#list model.primaryKeyList as p>
			${p.column} = ${sharp}{${p.name},jdbcType=${p.jdbcType}} <#if p_has_next>AND </#if>
		</#list>
	</#macro>

	<resultMap id="result" type="${model.modelBeanClass}">
	<#list model.columnList as p>
		<@resultColumn p.columnAlias?has_content?string(p.columnAlias!, p.column), p/>
	</#list>
	<#list model.joinColumnList as p>
		<@resultColumn p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn), p/>
	</#list>
	<#list model.sqlExpressionList as p>
		<@resultColumn p.columnAlias, p/>
	</#list>
	</resultMap>

	<select id="countByPrimaryKey" parameterType="${model.modelBeanClass}" resultType="int">
		SELECT /* ${model.name}.countByPrimaryKey */
			COUNT(1)
		FROM 
			${model.table} ${model.asTableAlias}
		WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="selectByPrimaryKey" parameterType="${model.modelBeanClass}" resultMap="result">
		SELECT /* ${model.name}.selectByPrimaryKey */
		<trim suffixOverrides=",">
		<#list model.columnList as p>
			${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}, 
<#if p.simpleJavaType?starts_with("Upload")>
			<@blobLength/>(${model.tableOrAlias}.${p.column}) AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}_LEN, 
</#if>
		</#list>
		<#list model.joinColumnList as p>
			${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}, 
<#if p.simpleJavaType?starts_with("Upload")>
			<@blobLength/>(${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn}) AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}_LEN, 
</#if>
		</#list>
		<#list model.sqlExpressionList as p>
			${p.sqlExpression?html} AS ${p.columnAlias}, 
		</#list>
		</trim>
		  FROM 
			<@fromWithJoins/>
		 WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="countByExample" parameterType="nuts.core.orm.dao.QueryParameter" resultType="int">
		SELECT /* ${model.name}.countByExample */
			COUNT(1)
		  FROM 
			<@fromWithJoins/>
		<include refid="Nuts.queryWhereClause"/>
	</select>

	<select id="selectByExample" parameterType="nuts.core.orm.dao.QueryParameter" resultMap="result">
		SELECT /* ${model.name}.selectByExample */
		<trim suffixOverrides=",">
		<choose>
			<when test="hasExcludes">
			<#list model.columnList as p>
				<choose>
					<when test="excludes['${p.name}']">
				<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}, 
					</when>
					<otherwise>
				${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}, 
					</otherwise>
				</choose>
<#if p.simpleJavaType?starts_with("Upload")>
				<choose>
					<when test="excludes['${p.name}.length']">
				<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}_LEN, 
					</when>
					<otherwise>
				<@blobLength/>(${model.tableOrAlias}.${p.column}) AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}_LEN, 
					</otherwise>
				</choose>
</#if>
			</#list>
			<#list model.joinColumnList as p>
				<choose>
					<when test="excludes['${p.name}']">
				<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}, 
					</when>
					<otherwise>
				${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}, 
					</otherwise>
				</choose>
<#if p.simpleJavaType?starts_with("Upload")>
				<choose>
					<when test="excludes['${p.name}.length']">
				<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}_LEN, 
					</when>
					<otherwise>
				<@blobLength/>(${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn}) AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}_LEN, 
					</otherwise>
				</choose>
</#if>
			</#list>
			<#list model.sqlExpressionList as p>
				<choose>
					<when test="excludes['${p.name}']">
				<@nullValue p/> AS ${p.columnAlias}, 
					</when>
					<otherwise>
				${p.sqlExpression?html} AS ${p.columnAlias}, 
					</otherwise>
				</choose>
			</#list>
			</when>
			<otherwise>
			<#list model.columnList as p>
				${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}, 
			</#list>
			<#list model.joinColumnList as p>
				${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}, 
			</#list>
			<#list model.sqlExpressionList as p>
				${p.sqlExpression?html} AS ${p.columnAlias}, 
			</#list>
			</otherwise>
		</choose>
		</trim>
		  FROM 
			<@fromWithJoins/>
		<include refid="Nuts.queryClause"/>
	</select>

	<#macro selectKey order, sql>
		<selectKey keyProperty="${model.identity}" resultType="${model.identityProperty.fullJavaType}" order="${order}">
			${sql}
		</selectKey>
	</#macro>
	<insert id="insert" parameterType="${model.modelBeanClass}">
	<#if model.identity?has_content>
		<#switch dbtype?upper_case>
		<#case "CLOUDSCAPE">
			<@selectKey order="AFTER" sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "DB2">
			<@selectKey order="AFTER" sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "DB2MF">
			<@selectKey order="AFTER" sql="VALUES SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1" />
			<#break>
		<#case "DERBY">
			<@selectKey order="AFTER" sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "HSQLDB">
			<@selectKey order="AFTER" sql="CALL IDENTITY()" />
			<#break>
		<#case "MSSQL">
			<@selectKey order="AFTER" sql="SELECT SCOPE_IDENTITY()" />
			<#break>
		<#case "MYSQL">
			<@selectKey order="AFTER" sql="SELECT LAST_INSERT_ID()" />
			<#break>
		<#case "ORACLE">
			<@selectKey order="BEFORE" sql="SELECT " + model.identitySequence!(model.table + "_SEQ") + ".NEXTVAL FROM DUAL" />
			<#break>
		<#case "POSTGRE">
			<#list model.columnList as p><#if model.identity == p.name>
			<@selectKey order="BEFORE" sql="SELECT NEXTVAL('" + (model.table + "_" + p.column + "_SEQ") + "')" />
			</#if></#list>
			<#break>
		<#case "SYBASE">
			<@selectKey order="AFTER" sql="SELECT @@IDENTITY" />
			<#break>
		</#switch>
	</#if>
		INSERT /* ${model.name}.insert */
			INTO ${model.table} (
		<#list model.columnList as p>
			${p.column}<#if p_has_next>, </#if>
		</#list>
		)
		VALUES (
		<#list model.columnList as p>
			${sharp}{${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}<#if p_has_next>, </#if>
		</#list>
		)
	</insert>

	<delete id="deleteByPrimaryKey" parameterType="${model.modelBeanClass}">
		DELETE /* ${model.name}.deleteByPrimaryKey */
		  FROM ${model.table}
		 WHERE
			<@whereByPrimaryKeyU/>
	</delete>

	<delete id="deleteByExample" parameterType="nuts.core.orm.dao.QueryParameter">
	<#switch dbtype?upper_case>
	<#case "MYSQL">
		DELETE /* ${model.name}.deleteByExample */
			${model.tableOrAlias}
		  FROM ${model.table} ${model.asTableAlias}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	<#default>
		DELETE /* ${model.name}.deleteByExample */
		  FROM ${model.table} ${model.asTableAlias}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	</#switch>
	</delete>

	<update id="updateByPrimaryKey" parameterType="${model.modelBeanClass}">
		UPDATE /* ${model.name}.updateByPrimaryKey */
			${model.table}
		<set>
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			${p.column} = ${sharp}{${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}<#if p_has_next>, </#if>
		</#if></#list>
		</set>
		 WHERE
			<@whereByPrimaryKeyU/>
	</update>

	<update id="updateByPrimaryKeySelective" parameterType="${model.modelBeanClass}">
		UPDATE /* ${model.name}.updateByPrimaryKeySelective */
			${model.table}
		<set>
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			<if test="${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if> != null">
				${p.column} = ${sharp}{${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}, 
			</if>
		</#if></#list>
		</set>
		 WHERE
			<@whereByPrimaryKeyU/>
	</update>

	<update id="updateByExample" parameterType="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE /* ${model.name}.updateByExampleExclude */
			${model.table} ${model.asTableAlias}
		<set>
			<choose>
				<when test="hasExcludes">
				<#list model.columnList as p><#if !(p.primaryKey!false)>
					<if test="!excludes['${p.name}']">
			${p.column} = ${sharp}{data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}, 
					</if>
				</#if></#list>
				</when>
				<otherwise>
				<#list model.columnList as p><#if !(p.primaryKey!false)>
			${p.column} = ${sharp}{data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}<#if p_has_next>, </#if>
				</#if></#list>
				</otherwise>
			</choose>
		</set>
		<include refid="Nuts.queryWhereClause"/>
	</update>

	<update id="updateByExampleSelective" parameterType="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE /* ${model.name}.updateByExampleSelective */
			${model.table} ${model.asTableAlias}
		<set>
			<#list model.columnList as p><#if !(p.primaryKey!false)>
			<if test="data.${p.name} != null">
			${p.column} = ${sharp}{data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>,jdbcType=${p.jdbcType}}, 
			</if>
			</#if></#list>
		</set>
		<include refid="Nuts.queryWhereClause"/>
	</update>
</mapper>
