<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "common.ftl"/>
package ${modelMetaDataPackage};

<#list imports as i>
import ${i};
</#list>

/**
 * ${modelMetaDataClass}
 *
 * This class was auto-generated by ${gen.class.name}
 * <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>
 */
public class ${modelMetaDataClass} extends ${class_name(model.baseMetaDataClass)}<${modelBeanClass}> {
	/**
	 * TABLE_NAME = "${model.table}";
	 */
	public static final String TABLE_NAME = "${model.table}";

	/**
	 * TABLE_ALIAS = "${model.tableAlias?has_content?string(model.tableAlias!, model.table)}";
	 */
	public static final String TABLE_ALIAS = "${model.tableAlias?has_content?string(model.tableAlias!, model.table)}";

<#list model.joinTableList as j>
	/**
	 * JOIN TABLE NAME: JTN_${j.joinTable} = "${j.joinTable}";
	 */
	public static final String JTN_${j.joinTable} = "${j.joinTable}";

<#if j.joinTableAlias?has_content>
	/**
	 * JOIN TABLE ALIAS: JTA_${j.joinTable}_${j.joinTableAlias} = "${j.joinTableAlias}";
	 */
	public static final String JTA_${j.joinTable}_${j.joinTableAlias} = "${j.joinTableAlias}";

</#if>
</#list>

	/*----------------------------------------------------------------------*
	 * PROPERTY NAMES
	 *----------------------------------------------------------------------*/
<#list model.propertyList as p>
	/**
	 * PN_${p.uname} = "${p.name}";
	 */
	public final static String PN_${p.uname} = "${p.name}";

</#list>

	/**
	 * PROPERTY_NAMES = { <#list model.propertyList as p>PN_${p.uname}<#if p_has_next>, </#if></#list> };
	 */
	public final static String PROPERTY_NAMES[] = new String[] { <#list model.propertyList as p>PN_${p.uname}<#if p_has_next>, </#if></#list> };

	/**
	 * IDENTITY = <#if model.identity?has_content>PN_${model.identity?upper_case}<#else>null</#if>;
	 */
	public final static String IDENTITY = <#if model.identity?has_content>PN_${model.identity?upper_case}<#else>null</#if>;

	/*----------------------------------------------------------------------*
	 * FIELD NAMES
	 *----------------------------------------------------------------------*/
<#list model.columnList as p>
	/**
	 * FN_${p.column?upper_case} = "${p.column}";
	 */
	public final static String FN_${p.column?upper_case} = "${p.column}";

</#list>

	/**
	 * FIELD_NAMES = { <#list model.columnList as p>FN_${p.column?upper_case}<#if p_has_next>, </#if></#list> };
	 */
	public final static String FIELD_NAMES[] = new String[] { <#list model.columnList as p>FN_${p.column?upper_case}<#if p_has_next>, </#if></#list> };

	/*----------------------------------------------------------------------*
	 * COLUMN NAMES
	 *----------------------------------------------------------------------*/
<#list model.columnList as p>
	/**
	 * CN_${model.tableAlias?has_content?string(model.tableAlias!, model.table)?upper_case}_${p.column?upper_case} = "${model.tableAlias?has_content?string(model.tableAlias!, model.table)}.${p.column}";
	 */
	public final static String CN_${model.tableAlias?has_content?string(model.tableAlias!, model.table)?upper_case}_${p.column?upper_case} = "${model.tableAlias?has_content?string(model.tableAlias!, model.table)}.${p.column}";

</#list>
<#if model.joinColumnList?has_content>

	/*----------------------------------------------------------------------*
	 * JOIN COLUMN NAMES
	 *----------------------------------------------------------------------*/
<#list model.joinColumnList as p>
	/**
	 * CN_${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)?upper_case}_${p.joinColumn?upper_case} = "${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn}";
	 */
	public final static String CN_${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)?upper_case}_${p.joinColumn?upper_case} = "${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn}";

</#list>
</#if>
<#if model.sqlExpressionList?has_content>

	/*----------------------------------------------------------------------*
	 * SELECT EXPRESSION COLUMN NAMES
	 *----------------------------------------------------------------------*/
<#list model.sqlExpressionList as p>
	/**
	 * CN_${p.columnAlias?upper_case} = "${p.sqlExpression}";
	 */
	public final static String CN_${p.columnAlias?upper_case} = "${p.sqlExpression}";

</#list>
</#if>

	/*----------------------------------------------------------------------*
	 * COLUMN ALIASES
	 *----------------------------------------------------------------------*/
<#list model.columnList as p>
	/**
	 * CA_${p.columnAlias?has_content?string(p.columnAlias!, p.column)?upper_case} = "${p.columnAlias?has_content?string(p.columnAlias!, p.column)}";
	 */
	public final static String CA_${p.columnAlias?has_content?string(p.columnAlias!, p.column)?upper_case} = "${p.columnAlias?has_content?string(p.columnAlias!, p.column)}";

</#list>
<#list model.joinColumnList as p>
	/**
	 * CA_${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)?upper_case} = "${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}";
	 */
	public final static String CA_${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)?upper_case} = "${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}";

</#list>
<#list model.sqlExpressionList as p>
	/**
	 * CA_${p.columnAlias?upper_case} = "${p.columnAlias}";
	 */
	public final static String CA_${p.columnAlias?upper_case} = "${p.columnAlias}";

</#list>

	/*----------------------------------------------------------------------*
	 * PRIMARY KEYS
	 *----------------------------------------------------------------------*/
	/**
	 * PRIMARY_KEYS = { <#list model.primaryKeyList as p>PN_${p.uname}<#if p_has_next>, </#if></#list> };
	 */
	public final static String[] PRIMARY_KEYS = { 
<#list model.primaryKeyList as p>
		PN_${p.uname}<#if p_has_next>, </#if>
</#list>
	};
	
	/**
	 * PRIMARY_KEY_CNS = { <#list model.primaryKeyList as p>CN_${model.tableAlias?has_content?string(model.tableAlias!, model.table)?upper_case}_${p.column?upper_case}<#if p_has_next>, </#if></#list> };
	 */
	public final static String[] PRIMARY_KEY_CNS = { 
<#list model.primaryKeyList as p>
		CN_${model.tableAlias?has_content?string(model.tableAlias!, model.table)?upper_case}_${p.column?upper_case}<#if p_has_next>, </#if>
</#list>
	};
	
	/**
	 * PRIMARY_KEY_CAS = { <#list model.primaryKeyList as p>CA_${p.columnAlias?has_content?string(p.columnAlias!, p.column)?upper_case}<#if p_has_next>, </#if></#list> };
	 */
	public final static String[] PRIMARY_KEY_CAS = { 
<#list model.primaryKeyList as p>
		CA_${p.columnAlias?has_content?string(p.columnAlias!, p.column)?upper_case}<#if p_has_next>, </#if>
</#list>
	};
	
	/*----------------------------------------------------------------------*
	 * CONSTRAINTS
	 *----------------------------------------------------------------------*/
	/**
	 * <PRE>
	 * UNIQUE_KEY_CONSTRAINTS = { 
<#list model.uniqueKeyMap?values as us>
	 *     { <#list us as p>PN_${p.uname}<#if p_has_next>, </#if></#list> }<#if us_has_next>, </#if>
</#list>
	 * };
	 * </PRE>
	 */
	public final static String[][] UNIQUE_KEY_CONSTRAINTS = { 
<#list model.uniqueKeyMap?values as us>
		{ <#list us as p>PN_${p.uname}<#if p_has_next>, </#if></#list> }<#if us_has_next>, </#if>
</#list>
	};
	
	/**
	 * <PRE>
	 * FOREIGN_KEY_CONSTRAINTS = { 
<#list model.foreignKeyList as fs>
	 *     { <#list fs as p><#if p.foreignTable?has_content>"${p.foreignTable}"<#break/></#if></#list>, <#list fs as p>PN_${p.uname}, "${p.foreignColumn}"</#list> }<#if fs_has_next>, </#if>
</#list>
	 * };
	 * </PRE>
	 */
	public final static String[][] FOREIGN_KEY_CONSTRAINTS = { 
<#list model.foreignKeyList as fs>
		{ <#list fs as p><#if p.foreignTable?has_content>"${p.foreignTable}"<#break/></#if></#list>, <#list fs as p>PN_${p.uname}, "${p.foreignColumn}"</#list> }<#if fs_has_next>, </#if>
</#list>
	};

	<#include "ModelMetaDataImpl.ftl"/>
}
