<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#list ui.displayFieldList as f>
<#assign p = ""/>
<#assign required = false/>
<#if f.modelField>
	<#list model.propertyList as mp>
		<#if mp.name == f.name>
			<#assign p = mp/>
			<#if requiredPK && p.primaryKey!false>
				<#assign required = true/>
			</#if>
			<#break/>
		</#if>
	</#list>
<#else>
	<#list action.propertyList as ap>
		<#if ap.name == f.name>
			<#assign p = ap/>
			<#break/>
		</#if>
	</#list>
</#if>
<#if f.required!false>
	<#assign required = true/>
</#if>
<#if (required!false) || f.validatorList?has_content>
	<#if p == "">${action.error("Can not find property [" + f.name + "] of model [" + model.name + "]")}</#if>
	<field name="<#if f.modelField>${actionDataFieldName}.</#if>${f.name}">
</#if>
<#if required!false>
		<field-validator type="required<#if p.simpleJavaType == 'String'>string<#elseif p.simpleJavaType?starts_with('Upload')>file</#if>">
			<message key="validation-required<#if p.simpleJavaType == 'String'>string<#elseif p.simpleJavaType?starts_with('Upload')>file</#if>"/>
		</field-validator>
	<#if p.simpleJavaType == 'UploadImage'>
		<field-validator type="image">
			<message key="validation-image"/>
		</field-validator>
	</#if>
</#if>
<#if f.validatorList?has_content>
	<#list f.validatorList as v>
		<field-validator type="${v.type}">
		<#if v.paramList?has_content><#list v.paramList as vp>
			<param name="${vp.name?html}">${vp.value?html}</param>
		</#list></#if>
			<message key="${v.message?html}"/>
		</field-validator>
	</#list>
</#if>
<#if (required!false) || f.validatorList?has_content>
	</field>
</#if>
</#list>
