<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "common.ftl"/>
package ${actionPackage};

<#list imports as i>
	<#if sqlDriven!false>
		<#if i != model.modelDaoClass && i != model.modelExampleClass>
import ${i};
		</#if>
	<#else>
		<#if i != model.modelSqlmapClass>
import ${i};
		</#if>
	</#if>
</#list>

/**
 * ${actionClass}
 *
 * This class was auto-generated by ${gen.class.name}
 * <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>
 */
public class ${actionClass} extends ${actionBaseClass}<${modelBeanClass}, ${modelExampleClass}> {
<#if action.propertyList?has_content>
	/*----------------------------------------------------------------------*
	 * Properties
	 *----------------------------------------------------------------------*/
<#list action.propertyList as p>
	protected <#if p.modifier?has_content>${p.modifier} </#if>${p.simpleJavaType} ${p.name}<#if p.initValue?has_content> = ${p.initValue}</#if>;
</#list>
</#if>

	/**
	 * Constructor
	 */
	public ${actionClass}() {
		setDataFieldName("${actionDataFieldName}");
		setDataListFieldName("${actionDataListFieldName}");
		setModelName(${modelMetaDataClass}.TABLE_NAME);
	}

	/**
	 * @return the ${modelBeanClass?uncap_first}
	 */
	public ${modelBeanClass} get${actionDataFieldName?cap_first}() {
		return super.getData();
	}

	/**
	 * @param ${modelBeanClass?uncap_first} the ${modelBeanClass?uncap_first} to set
	 */
	public void set${actionDataFieldName?cap_first}(${modelBeanClass} ${modelBeanClass?uncap_first}) {
		super.setData(${modelBeanClass?uncap_first});
	}

	/**
	 * @return the ${modelBeanClass?uncap_first} list
	 */
	public List<${modelBeanClass}> get${actionDataListFieldName?cap_first}() {
		return super.getDataList();
	}

	/**
	 * @param ${modelBeanClass?uncap_first}List the ${modelBeanClass?uncap_first}List to set
	 */
	public void set${actionDataListFieldName?cap_first}(List<${modelBeanClass}> ${modelBeanClass?uncap_first}List) {
		super.setDataList(${modelBeanClass?uncap_first}List);
	}

<#list action.propertyList as p>
	/**
	 * @return the ${p.name}
	 */
	public ${p.simpleJavaType} get${p.name?cap_first}() {
	<#assign getterTrim = "" />
	<#if p.getterTrim??>
		<#if p.getterTrim?has_content>
			<#assign getterTrim = p.getterTrim/>
		</#if>
	</#if>
	<#if p.getterCode?has_content>
		${p.getterCode}
	<#elseif getterTrim?has_content>
		return ${getterTrim}(${p.name});
	<#else>
		return ${p.name};
	</#if>
	}

	/**
	 * @param ${p.name} the ${p.name} to set
	 */
	public void set${p.name?cap_first}(${p.simpleJavaType} ${p.name}) {
	<#assign setterTrim = "" />
	<#if p.setterTrim??>
		<#if p.setterTrim?has_content>
			<#assign setterTrim = p.setterTrim/>
		</#if>
	<#elseif action.trimString?has_content && p.simpleJavaType == "String">
		<#assign setterTrim = action.trimString />
	</#if>
	<#if p.setterCode?has_content>
		${p.setterCode}
	<#elseif setterTrim?has_content>
		this.${p.name} = ${setterTrim}(${p.name});
	<#else>
		this.${p.name} = ${p.name};
	</#if>
	}

</#list>
	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	protected ${modelBeanClass} prepareDefaultData(${modelBeanClass} data) throws Exception {
		if (data == null) {
			data = new ${modelBeanClass}();
		}
		return data;
	}

<#if action.listUIList?has_content><#list action.listUIList as ui><#if ui.generate!false>
<#if ui.templates?seq_contains("list")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
<#elseif ui.templates?seq_contains("list_popup")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		addLimitToPager();
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
<#elseif ui.templates?seq_contains("list_csv") || ui.templates?seq_contains("list_print")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		if (get_load() == null) {
			set_load(false);
		}
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
<#elseif ui.templates?seq_contains("bdelete")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doBulkDeleteSelect();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doBulkDeleteExecute();
	}
	
<#elseif ui.templates?seq_contains("bupdate")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doBulkUpdateSelect();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doBulkUpdateExecute();
	}
	
<#elseif ui.templates?seq_contains("bedit")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doBulkEditInput();
	}

	/**
	 * ${ui.name}_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_input() throws Exception {
		return doBulkEditInput();
	}

	/**
	 * ${ui.name}_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_confirm() throws Exception {
		return doBulkEditConfirm();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doBulkEditExecute();
	}
	
</#if>
</#if></#list></#if>
<#if action.inputUIList?has_content><#list action.inputUIList as ui><#if ui.generate!false>
<#if ui.templates?seq_contains("view") || ui.templates?seq_contains("print")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doViewSelect();
	}

	/**
	 * ${ui.name}_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_input() throws Exception {
		return doViewInput();
	}

<#elseif ui.templates?seq_contains("insert") || ui.templates?seq_contains("copy")>
	<#if ui.templates?seq_contains("insert")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doInsertClear();
	}
	<#else>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doInsertSelect();
	}
	</#if>

	/**
	 * ${ui.name}_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_input() throws Exception {
		return doInsertInput();
	}

	/**
	 * ${ui.name}_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_confirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doInsertExecute();
	}

<#elseif ui.templates?seq_contains("update")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doUpdateSelect();
	}

	/**
	 * ${ui.name}_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_input() throws Exception {
		return doUpdateInput();
	}

	/**
	 * ${ui.name}_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_confirm() throws Exception {
		return doUpdateConfirm();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doUpdateExecute();
	}

<#elseif ui.templates?seq_contains("delete")>
	/**
	 * ${ui.name}
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}() throws Exception {
		return doDeleteSelect();
	}

	/**
	 * ${ui.name}_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String ${ui.name}_execute() throws Exception {
		return doDeleteExecute();
	}

</#if>
</#if></#list></#if>
}