/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.poi.ppt;

import java.util.LinkedHashMap;
import java.util.Map;

import nuts.tools.poi.ESummary;

public class ESlideShow {
	private ESummary summary;
	private EHeaderFooter headers;
	private Map<String, ESlide> masters = new LinkedHashMap<String, ESlide>();
	private Map<String, ESlide> slides = new LinkedHashMap<String, ESlide>();

	/**
	 * @return the summary
	 */
	public ESummary getSummary() {
		return summary;
	}

	/**
	 * @param summary the summary to set
	 */
	public void setSummary(ESummary summary) {
		this.summary = summary;
	}


	/**
	 * @return the headers
	 */
	public EHeaderFooter getHeaders() {
		return headers;
	}

	/**
	 * @param headers the headers to set
	 */
	public void setHeaders(EHeaderFooter headers) {
		this.headers = headers;
	}

	/**
	 * @return the masters
	 */
	public Map<String, ESlide> getMasters() {
		return masters;
	}

	/**
	 * @param masters the masters to set
	 */
	public void setMasters(Map<String, ESlide> masters) {
		this.masters = masters;
	}

	/**
	 * @return the slides
	 */
	public Map<String, ESlide> getSlides() {
		return slides;
	}

	/**
	 * @param slides the slides to set
	 */
	public void setSlides(Map<String, ESlide> slides) {
		this.slides = slides;
	}

}

