/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.poi.doc;

import java.util.Map;

import nuts.tools.poi.ESummary;


public class EDocument {
	private ESummary summary;
	private Map<Integer, EParagraph> main;
	private Map<Integer, EParagraph> comments;
	private Map<Integer, EParagraph> footnote;
	private Map<Integer, EParagraph> endnote;
	private Map<Integer, EParagraph> header;
	private Map<Integer, EParagraph> textbox;
	
	/**
	 * @return the summary
	 */
	public ESummary getSummary() {
		return summary;
	}

	/**
	 * @param summary the summary to set
	 */
	public void setSummary(ESummary summary) {
		this.summary = summary;
	}

	/**
	 * @return the main
	 */
	public Map<Integer, EParagraph> getMain() {
		return main;
	}

	/**
	 * @param main the main to set
	 */
	public void setMain(Map<Integer, EParagraph> main) {
		this.main = main;
	}

	/**
	 * @return the comments
	 */
	public Map<Integer, EParagraph> getComments() {
		return comments;
	}

	/**
	 * @param comments the comments to set
	 */
	public void setComments(Map<Integer, EParagraph> comments) {
		this.comments = comments;
	}

	/**
	 * @return the footnote
	 */
	public Map<Integer, EParagraph> getFootnote() {
		return footnote;
	}

	/**
	 * @param footnote the footnote to set
	 */
	public void setFootnote(Map<Integer, EParagraph> footnote) {
		this.footnote = footnote;
	}

	/**
	 * @return the endnote
	 */
	public Map<Integer, EParagraph> getEndnote() {
		return endnote;
	}

	/**
	 * @param endnote the endnote to set
	 */
	public void setEndnote(Map<Integer, EParagraph> endnote) {
		this.endnote = endnote;
	}

	/**
	 * @return the header
	 */
	public Map<Integer, EParagraph> getHeader() {
		return header;
	}

	/**
	 * @param header the header to set
	 */
	public void setHeader(Map<Integer, EParagraph> header) {
		this.header = header;
	}

	/**
	 * @return the textbox
	 */
	public Map<Integer, EParagraph> getTextbox() {
		return textbox;
	}

	/**
	 * @param textbox the textbox to set
	 */
	public void setTextbox(Map<Integer, EParagraph> textbox) {
		this.textbox = textbox;
	}

}

