/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.poi;

import org.apache.poi.hpsf.SummaryInformation;
import org.w3c.dom.Element;


public class ESummary {
	private String title;
	private String author;
	private String comments;
	private String keywords;
	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * @return the author
	 */
	public String getAuthor() {
		return author;
	}
	/**
	 * @param author the author to set
	 */
	public void setAuthor(String author) {
		this.author = author;
	}
	/**
	 * @return the comments
	 */
	public String getComments() {
		return comments;
	}
	/**
	 * @param comments the comments to set
	 */
	public void setComments(String comments) {
		this.comments = comments;
	}
	/**
	 * @return the keywords
	 */
	public String getKeywords() {
		return keywords;
	}
	/**
	 * @param keywords the keywords to set
	 */
	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}
	
	public void set(SummaryInformation si) {
		si.setTitle(getTitle());
		si.setAuthor(getAuthor());
		si.setComments(getComments());
		si.setKeywords(getKeywords());
	}
	
	public void copy(SummaryInformation si) {
		setTitle(si.getTitle());
		setAuthor(si.getAuthor());
		setComments(si.getComments());
		setKeywords(si.getKeywords());
	}
	
	public void copy(Element el) {
		setAuthor(el.getAttribute("author"));
		setComments(el.getAttribute("comments"));
		setKeywords(el.getAttribute("keywords"));
		setTitle(el.getAttribute("title"));
	}
}
