/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.esort;

import nuts.core.util.progressbar.ConsoleGaugeBar;
import nuts.core.util.progressbar.ConsolePercentBar;
import nuts.core.util.progressbar.ConsoleRemainTimeBar;
import nuts.core.util.progressbar.ConsoleWindmillBar;

/**
 * @author fsoft
 */
public class Main {

	/**
	 * @param args arguments
	 */
	public static void main(String[] args) {
		try {
			ConsolePercentBar p = new ConsolePercentBar();
			p.start();
			for (int i = 0; i <= 100; i++) {
				Thread.sleep(10);
				p.setValue(i);
			}
			p.stop();
			System.out.println();

			ConsoleGaugeBar g = new ConsoleGaugeBar();
			g.start();
			for (int i = 0; i <= 100; i++) {
				Thread.sleep(10);
				g.setValue(i);
			}
			g.stop();
			System.out.println();
			
			g = new ConsoleGaugeBar();
			g.setDrawPercent(true);
			g.start();
			for (int i = 0; i <= 100; i++) {
				Thread.sleep(10);
				g.setValue(i);
			}
			g.stop();
			System.out.println();
			
			ConsoleWindmillBar w = new ConsoleWindmillBar();
			w.start();
			Thread.sleep(3000);
			w.stop();
			System.out.println();
			
			System.out.print("Remain time: ");
			ConsoleRemainTimeBar r = new ConsoleRemainTimeBar();
			r.start();
			for (int i = 0; i <= 100; i++) {
				Thread.sleep(300);
				r.setValue(i);
			}
			r.stop();
			System.out.println();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

}
