/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.crypto;

import nuts.core.util.StringCryptoUtils;

/**
 */
public class Encrypt {
	/**
	 * @param args arguments
	 */
	public static void main(String[] args) {
		if (args.length < 1) {
			System.out.println("Encrypt <string>");
		}
		
		Encrypt c = new Encrypt();
		for (String a : args) {
			c.setText(a);
			try {
				c.execute();
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Constructor
	 */
	public Encrypt() {
	}

	//---------------------------------------------------------------------------------------
	// properties
	//---------------------------------------------------------------------------------------
	protected String text;

	/**
	 * @return the text
	 */
	public String getText() {
		return text;
	}

	/**
	 * @param text the text to set
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * execute
	 * @throws Exception if an error occurs
	 */
	public void execute() throws Exception {
		System.out.println(StringCryptoUtils.encrypt(text));
	}
}
