/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs.provider;

import nuts.core.lang.PrivateAccessUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.VFS;

/**
 * gae file system
 */
public class GaeVFS {
	private static Log log = LogFactory.getLog(GaeVFS.class);

	/**
	 * init
	 */
	public static void init() throws Exception {
		// GAE doesn't set these values; Commons VFS will fail to initialize if
		// they're not set, so do it here
		if (System.getProperty("os.name") == null) {
			System.setProperty("os.name", "gae");
		}
		if (System.getProperty("os.arch") == null) {
			System.setProperty("os.arch", "gae");
		}
		if (System.getProperty("os.version") == null) {
			System.setProperty("os.version", "1.0");
		}

		if (log.isDebugEnabled()) {
			log.debug("os.name: " + System.getProperty("os.name"));
			log.debug("os.arch: " + System.getProperty("os.arch"));
			log.debug("os.version: " + System.getProperty("os.version"));
		}
		
		GaeFileSystemManager fsm = new GaeFileSystemManager();

		fsm.init();

		PrivateAccessUtils.setStaticFieldValue(VFS.class, "instance", fsm);
	}
}
