/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs.provider;

import nuts.core.orm.dao.DataAccessClient;
import nuts.core.orm.dao.DataAccessSession;
import nuts.exts.vfs.ndfs.NdfsFileSystem;
import nuts.exts.vfs.ndfs.dao.NdfsData;
import nuts.exts.vfs.ndfs.dao.NdfsDataDAO;
import nuts.exts.vfs.ndfs.dao.NdfsDataExample;
import nuts.exts.vfs.ndfs.dao.NdfsFile;
import nuts.exts.vfs.ndfs.dao.NdfsFileDAO;
import nuts.exts.vfs.ndfs.dao.NdfsFileExample;
import nuts.gae.vfs.ngfs.GaeDataMetaData;
import nuts.gae.vfs.ngfs.GaeFileMetaData;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemOptions;

/**
 */
@SuppressWarnings("serial")
public class GaeFileSystem extends NdfsFileSystem {

	/**
	 * @param rootName root name
	 * @param fileSystemOptions options
	 * @param dataAccessClient data access client
	 */
	protected GaeFileSystem(FileName rootName, 
			FileSystemOptions fileSystemOptions,
			DataAccessClient dataAccessClient) {
		
		super(rootName, fileSystemOptions, dataAccessClient);
		
		//GAE has max entity size limit (1,000,000)
		this.setBlockSize(999000);
	}

	@SuppressWarnings("unchecked")
	@Override
	public NdfsFileDAO<NdfsFile, NdfsFileExample> createFileDAO(DataAccessSession session) {
		return (NdfsFileDAO<NdfsFile, NdfsFileExample>)getDataAccessClient().getModelDAO(GaeFileMetaData.TABLE_NAME, session);
	}

	@SuppressWarnings("unchecked")
	@Override
	public NdfsDataDAO<NdfsData, NdfsDataExample> createDataDAO(DataAccessSession session) {
		return (NdfsDataDAO<NdfsData, NdfsDataExample>)getDataAccessClient().getModelDAO(GaeDataMetaData.TABLE_NAME, session);
	}
}
