/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs;

import nuts.core.orm.restriction.ComparableRestriction;
import nuts.exts.vfs.ndfs.dao.NdfsDataExample;
import nuts.gae.dao.GaeQueryParameter;

import com.google.appengine.api.datastore.Query;

/**
 */
@SuppressWarnings("serial")
public class GaeDataExample extends GaeQueryParameter implements NdfsDataExample {
	/**
	 * Constructor
	 */
	public GaeDataExample() {
		super();
		setQuery(new Query(GaeDataMetaData.TABLE_NAME));
	}

	/**
	 * append AND
	 * @return this
	 */
	public GaeDataExample and() {
		getRestrictions().and();
		return this;
	}

	//----------------------------------------------------------------------
	// ALL exclude & include
	//----------------------------------------------------------------------
	/**
	 * excludeALL
	 * @return this
	 */
	public GaeDataExample excludeALL() {
	 	addExclude(GaeDataMetaData.PN_ID);
	 	addExclude(GaeDataMetaData.PN_DATA);
		return this;
	}

	/**
	 * includeALL
	 * @return this
	 */
	public GaeDataExample includeALL() {
		clearExcludes();
		return this;
	}

	//----------------------------------------------------------------------
	// column restrictions
	//----------------------------------------------------------------------
	/**
	 * @return restriction of id
	 */
	public ComparableRestriction<NdfsDataExample, Long> id() {
		return new ComparableRestriction<NdfsDataExample, Long>(this, GaeDataMetaData.PN_ID);
	}

	/**
	 * @return restriction of fileId
	 */
	public ComparableRestriction<NdfsDataExample, Long> fileId() {
		return new ComparableRestriction<NdfsDataExample, Long>(this, GaeDataMetaData.PN_FILE_ID);
	}

	/**
	 * @return restriction of itemNo
	 */
	public ComparableRestriction<NdfsDataExample, Integer> itemNo() {
		return new ComparableRestriction<NdfsDataExample, Integer>(this, GaeDataMetaData.PN_ITEM_NO);
	}
}

