package nuts.gae.taskqueue;

import java.util.Map.Entry;

import nuts.core.taskqueue.TaskQueue;
import nuts.core.taskqueue.TaskQueueOptions;

import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.TaskOptions;

public class GaeTaskQueue extends TaskQueue {

	private Queue queue;
	
	public GaeTaskQueue(Queue queue) {
		this.queue = queue;
	}
	
	public void add(TaskQueueOptions tqo) {
		TaskOptions to = TaskOptions.Builder.withDefaults();

		to.url(tqo.getUrl());
		
		to.headers(tqo.getHeaders());
		for (Entry<String, String> en : tqo.getParams().entrySet()) {
			to.param(en.getKey(), en.getValue());
		}

		queue.add(to);
	}
}
