/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.io.IOUtils;
import nuts.core.lang.CharsetUtils;
import nuts.core.lang.StringUtils;

/**
 */
@SuppressWarnings("serial")
public class AppstatsServlet extends com.google.appengine.tools.appstats.AppstatsServlet {

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		
		String uri = req.getRequestURI();
		String type = IOUtils.getContentTypeFor(uri);
		
		res.setCharacterEncoding(CharsetUtils.UTF_8);
		if (StringUtils.isEmpty(type)) {
			String ext = IOUtils.getFileNameExtension(uri);
			if (StringUtils.isEmpty(ext)) {
				type = "text/html";
			}
		}
		
		if (StringUtils.isNotEmpty(type)) {
			res.setContentType(type + ";charset=" + CharsetUtils.UTF_8);
		}
		
		super.service(req, res);
	}
}
