/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.dao;

import java.util.Properties;

import nuts.core.orm.dao.AbstractDataAccessClient;
import nuts.core.orm.dao.DataAccessSession;

import com.google.appengine.api.datastore.DatastoreService;

/**
 */
public class GaeDataAccessClient extends AbstractDataAccessClient implements DatastoreServiceAware {
	
	private DatastoreService service;
	
	/**
	 */
	public GaeDataAccessClient() {
		super();
	}

	/**
	 * @param service the service to set
	 */
	public GaeDataAccessClient(DatastoreService service, Properties props) {
		super(props);
		this.service = service;
	}

	/**
	 * @return the service
	 */
	public DatastoreService getDatastoreService() {
		return service;
	}

	/**
	 * @param service the service to set
	 */
	public void setDatastoreService(DatastoreService service) {
		this.service = service;
	}

	/**
	 * open session
	 * @return DataAccessSession
	 */
	public DataAccessSession openSession(boolean autoCommit) {
		return new GaeDataAccessSession(this, service, autoCommit);
	}

}
