/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.flex.util {
	import flash.external.ExternalInterface;
	
	public class Cookie {
		public function Cookie() {
		}
		
		private static const FUNCTION_SETCOOKIE:String = 
            "document.insertScript = function() {" +
                "if (document.snw_setCookie == null) {" +
                    "nuts_setCookie = function(name, value, days) {" +
                        "if (days) {"+
							"var date = new Date();"+
							"date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));"+
							"var expires = '; expires='+date.toGMTString();"+
						"}" +
						"else {" + 
							"var expires = '';" +
						"}" +
						"document.cookie = name + '=' + value + expires + '; path=/';" +
		            "}" +
                "}" +
            "}";
		
		private static const FUNCTION_GETCOOKIE:String = 
            "document.insertScript = function() {" +
                "if (document.nuts_getCookie == null) {" +
                    "nuts_getCookie = function(name) {" +
                        "var nameEQ = name + '=';"+
						"var ca = document.cookie.split(';');"+
						"for (var i = 0; i < ca.length; i++) {"+
							"var c = ca[i];"+
							"while (c.charAt(0) == ' ') {" +
								"c = c.substring(1, c.length);" +
							"}" +
							"if (c.indexOf(nameEQ) == 0) {" +
								"return c.substring(nameEQ.length,c.length);" +
						"}" +
						"return null;" +
		            "}" +
                "}" +
            "}";
     
            
        private static var _init:Boolean = false;
		
		private static function init():void {
			if (!_init) {
				ExternalInterface.call(FUNCTION_GETCOOKIE);
				ExternalInterface.call(FUNCTION_SETCOOKIE);
				_init = true;
			}
		}
		
		public static function setCookie(name:String, value:Object, days:int):void {
			init();
			
			ExternalInterface.call("nuts_setCookie", name, value, days);
		}
		
		public static function getCookie(name:String):Object {
			init();
			
			return ExternalInterface.call("nuts_getCookie", name);
		}
		
		public static function deleteCookie(name:String):void {
			init();
			
			ExternalInterface.call("nuts_setCookie", name, "", -1);
		}

	}
}