/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.flex.controls {
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import mx.controls.Button;

	/**
	 * スペースキーだけでなく、Enter キーでもクリックイベントが発動するボタン
	 */
	public class EnterButton extends Button {
	    override protected function keyDownHandler(event:KeyboardEvent):void {
	        if (event.keyCode == Keyboard.ENTER) {
	            event.keyCode = Keyboard.SPACE;
	        }
	        super.keyDownHandler(event);
	    }
	    
	    override protected function keyUpHandler(event:KeyboardEvent):void {
	        if (event.keyCode == Keyboard.ENTER) {
	            event.keyCode = Keyboard.SPACE;
	        }
	        super.keyUpHandler(event);
	    }
		
	}
}

