/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2;


/**
 * PermissionValidationAware
 */
public interface PermissionValidator {
	/**
	 * hasPermission
	 * @param action action
	 * @return true if action has access permission
	 */
	boolean hasPermission(String action);

	/**
	 * hasPermission
	 * @param namespace namespace
	 * @param action action
	 * @return true if action has access permission
	 */
	boolean hasPermission(String namespace, String action);

	/**
	 * hasDataPermission
	 * @param data data
	 * @param action action
	 * @return true if action has access permission
	 */
	boolean hasDataPermission(Object data, String action);

	/**
	 * hasDataPermission
	 * @param data data
	 * @param namespace namespace
	 * @param action action
	 * @return true if action has access permission
	 */
	boolean hasDataPermission(Object data, String namespace, String action);

}
