/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.jsp.ui;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.exts.struts2.components.ListView;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ui.AbstractUITag;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * @see ListView
 */
@SuppressWarnings("serial")
public class ListViewTag extends AbstractUITag {
	
	// attributes
    protected Object list;
    protected Object columns;
    protected Object querys;

    protected String start;
    protected String limit;
    protected String total;
    protected String sort;
    protected String dir;
	protected String filters;
	protected String filterm;
	protected String query;
	
    protected String sortable;
    protected String autosize;
    protected String script;
	protected String cssColumn;
	protected String action;
	protected String method;
	protected String target;
	protected String onsubmit;
	protected String onreset;

	protected String pager;
	protected String tools;
	protected String addon;
	protected String headPager;
	protected String headTools;
	protected String headAddon;
	protected String footPager;
	protected String footTools;
	protected String footAddon;

	protected Object link;

	protected String singleSelect;
	protected String toggleSelect;
	protected String onrowclick;

	protected String checkAllToolButton;
	
	/**
	 * @param list the list to set
	 */
	public void setList(Object list) {
		this.list = list;
	}

	/**
	 * @param columns the columns to set
	 */
	public void setColumns(Object columns) {
		this.columns = columns;
	}

	/**
	 * @param querys the querys to set
	 */
	public void setQuerys(Object querys) {
		this.querys = querys;
	}

	/**
	 * @param start the start to set
	 */
	public void setStart(String start) {
		this.start = start;
	}

	/**
	 * @param limit the limit to set
	 */
	public void setLimit(String limit) {
		this.limit = limit;
	}

	/**
	 * @param total the total to set
	 */
	public void setTotal(String total) {
		this.total = total;
	}

	/**
	 * @param sort the sort to set
	 */
	public void setSort(String sort) {
		this.sort = sort;
	}

	/**
	 * @param dir the dir to set
	 */
	public void setDir(String dir) {
		this.dir = dir;
	}

	/**
	 * @param filters the filters to set
	 */
	public void setFilters(String filters) {
		this.filters = filters;
	}

	/**
	 * @param filterm the filterm to set
	 */
	public void setFilterm(String filterm) {
		this.filterm = filterm;
	}

	/**
	 * @param query the query to set
	 */
	public void setQuery(String query) {
		this.query = query;
	}

	/**
	 * @param sortable the sortable to set
	 */
	public void setSortable(String sortable) {
		this.sortable = sortable;
	}

	/**
	 * @param autosize the autosize to set
	 */
	public void setAutosize(String autosize) {
		this.autosize = autosize;
	}

	/**
	 * @param script the script to set
	 */
	public void setScript(String script) {
		this.script = script;
	}

	/**
	 * @param cssColumn the cssColumn to set
	 */
	public void setCssColumn(String cssColumn) {
		this.cssColumn = cssColumn;
	}

	/**
	 * @param action the action to set
	 */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @param method the method to set
	 */
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * @param target the target to set
	 */
	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 * @param onsubmit the onsubmit to set
	 */
	public void setOnsubmit(String onsubmit) {
		this.onsubmit = onsubmit;
	}

	/**
	 * @param onreset the onreset to set
	 */
	public void setOnreset(String onreset) {
		this.onreset = onreset;
	}

	/**
	 * @param pager the pager to set
	 */
	public void setPager(String pager) {
		this.pager = pager;
	}

	/**
	 * @param tools the tools to set
	 */
	public void setTools(String tools) {
		this.tools = tools;
	}

	/**
	 * @param addon the addon to set
	 */
	public void setAddon(String addon) {
		this.addon = addon;
	}

	/**
	 * @param headPager the headPager to set
	 */
	public void setHeadPager(String headPager) {
		this.headPager = headPager;
	}

	/**
	 * @param headTools the headTools to set
	 */
	public void setHeadTools(String headTools) {
		this.headTools = headTools;
	}

	/**
	 * @param headAddon the headAddon to set
	 */
	public void setHeadAddon(String headAddon) {
		this.headAddon = headAddon;
	}

	/**
	 * @param footPager the footPager to set
	 */
	public void setFootPager(String footPager) {
		this.footPager = footPager;
	}

	/**
	 * @param footTools the footTools to set
	 */
	public void setFootTools(String footTools) {
		this.footTools = footTools;
	}

	/**
	 * @param footAddon the footAddon to set
	 */
	public void setFootAddon(String footAddon) {
		this.footAddon = footAddon;
	}

	/**
	 * @param link the link to set
	 */
	public void setLink(Object link) {
		this.link = link;
	}

	/**
	 * @param singleSelect the singleSelect to set
	 */
	public void setSingleSelect(String singleSelect) {
		this.singleSelect = singleSelect;
	}

	/**
	 * @param toggleSelect the toggleSelect to set
	 */
	public void setToggleSelect(String toggleSelect) {
		this.toggleSelect = toggleSelect;
	}

	/**
	 * @param onrowclick the onrowclick to set
	 */
	public void setOnrowclick(String onrowclick) {
		this.onrowclick = onrowclick;
	}

	/**
	 * @param checkAllToolButton the checkAllToolButton to set
	 */
	public void setCheckAllToolButton(String checkAllToolButton) {
		this.checkAllToolButton = checkAllToolButton;
	}

	/**
     * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public Component getBean(ValueStack stack, HttpServletRequest req,
        HttpServletResponse res) {
        return new ListView(stack, req, res);
    }

    /**
     * @see org.apache.struts2.views.jsp.ui.AbstractUITag#populateParams()
     */
    protected void populateParams() {
        super.populateParams();

        ListView lv = ((ListView) component);

        lv.setList(list);
        lv.setColumns(columns);

        //deprecated
        lv.setQuerys(querys);
        lv.setQuery(query);

        lv.setStart(start);
        lv.setLimit(limit);
        lv.setTotal(total);
        lv.setSort(sort);
        lv.setDir(dir);
        lv.setFilters(filters);
        lv.setFilterm(filterm);

        lv.setSortable(sortable);
        lv.setAutosize(autosize);
        lv.setScript(script);
        lv.setCssColumn(cssColumn);
        lv.setAction(action);
        lv.setMethod(method);
        lv.setTarget(target);
        lv.setOnsubmit(onsubmit);
        lv.setOnreset(onreset);

        lv.setHeadPager(headPager);
        lv.setHeadTools(headTools);
        lv.setHeadAddon(headAddon);
        lv.setFootPager(footPager);
        lv.setFootTools(footTools);
        lv.setFootAddon(footAddon);

        lv.setLink(link);

        lv.setSingleSelect(singleSelect);
        lv.setToggleSelect(toggleSelect);
        lv.setOnrowclick(onrowclick);
        
        lv.setCheckAllToolButton(checkAllToolButton);
    }
}
