/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import org.apache.struts2.components.template.TemplateRenderingContext;


public class NutsFormRenderer extends AbstractTemplateRenderer {
	public NutsFormRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        attrs.id(params)
        	.name(params)
        	.cssClass(params, "n-form")
        	.action(params)
        	.target(params)
        	.add("method", defs((String) params.get("method"), "post"))
        	.enctype(params)
        	.acceptcharset(params)
        	.title(params)
        	.onsubmit(params)
        	.onreset(params)
        	.addIfExists("hooked", params.get("hooked"))
        	.addIfExists("loadmask", params.get("loadmask"))
        	.cssStyle(params)
        	.commons(params)
        	.events(params)
        	.dynamics(params);
        stag("form", attrs);
    }

    public static class Close extends AbstractTemplateRenderer {
        public Close(TemplateRenderingContext context) {
			super(context);
		}

		public void render() throws IOException {
            etag("form");
        }
    }
}
