/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

/**
 * Character implementation of TypeHandler
 */
public class CharacterTypeHandler implements TypeHandler {

	/**
	 */
	public void setParameter(PreparedStatement ps, int i, Object parameter,
			JdbcType jdbcType) throws SQLException {
		String val = null;
		if (parameter != null) {
			val = String.valueOf(parameter);
		}
		ps.setString(i, val);
	}

	/**
	 */
	public Object getResult(ResultSet rs, String columnName)
			throws SQLException {
		String s = rs.getString(columnName);
		if (rs.wasNull() || s.length() < 1) {
			return null;
		}
		else {
			return s.charAt(0);
		}
	}

	/**
	 */
	public Object getResult(CallableStatement cs, int columnIndex)
			throws SQLException {
		String s = cs.getString(columnIndex);
		if (cs.wasNull() || s.length() < 1) {
			return null;
		}
		else {
			return s.charAt(0);
		}
	}
}
