/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.freemarker;

import java.net.URL;

import nuts.core.lang.ClassLoaderUtils;
import freemarker.cache.URLTemplateLoader;

/**
 * ClassTemplateLoader
 */
public class ClassTemplateLoader extends URLTemplateLoader {

	private String path;

	/**
	 * Constructor
	 */
	public ClassTemplateLoader() {
		this("/");
	}

	/**
	 * Constructor
	 * @param path the base path to template resources. 
	 */
	public ClassTemplateLoader(String path) {
		setPath(path);
	}

	private void setPath(String path) {
		if (path == null) {
			throw new IllegalArgumentException("path == null");
		}
		this.path = canonicalizePrefix(path);
	}

	protected URL getURL(String name) {
		if (name.startsWith("/")) {
			name = name.substring(1);
		}
		return ClassLoaderUtils.getResourceAsURL(path + name, getClass());
	}
}
